% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getRCI}
\alias{getRCI}
\title{Repeated Confidence Interval for Group Sequential Design}
\usage{
getRCI(
  L = NA_integer_,
  zL = NA_real_,
  IMax = NA_real_,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{L}{The look of interest.}

\item{zL}{The z-test statistic at the look.}

\item{IMax}{The maximum information of the trial.}

\item{informationRates}{The information rates up to look \code{L}.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is
allowed at each stage up to look \code{L}. Defaults to true
if left unspecified.}

\item{criticalValues}{The upper boundaries on the z-test statistic scale
for efficacy stopping up to look \code{L}.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending.
One of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early efficacy stopping.
Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value of alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{spendingTime}{The error spending time up to look \code{L}.
Defaults to missing, in which case, it is the same as
\code{informationRates}.}
}
\value{
A data frame with the following components:
\itemize{
\item \code{pvalue}: Repeated p-value for rejecting the null hypothesis.
\item \code{thetahat}: Point estimate of the parameter.
\item \code{cilevel}: Confidence interval level.
\item \code{lower}: Lower bound of repeated confidence interval.
\item \code{upper}: Upper bound of repeated confidence interval.
}
}
\description{
Obtains the repeated confidence interval
for a group sequential trial.
}
\examples{

# group sequential design with 90\% power to detect delta = 6
delta = 6
sigma = 17
n = 282
(des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3,
                  alpha = 0.05, typeAlphaSpending = "sfHSD",
                  parameterAlphaSpending = -4))

# results at the second look
L = 2
n1 = n*2/3
delta1 = 7
sigma1 = 20
zL = delta1/sqrt(4/n1*sigma1^2)

# repeated confidence interval
getRCI(L = L, zL = zL, IMax = n/(4*sigma1^2),
       informationRates = c(1/3, 2/3), alpha = 0.05,
       typeAlphaSpending = "sfHSD", parameterAlphaSpending = -4)

}
\references{
Christopher Jennison and Bruce W. Turnbull.
Interim analyses: the repeated confidence interval approach
(with discussion).
J R Stat Soc Series B. 1989;51:305-361.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
