% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{patrisk}
\alias{patrisk}
\title{Probability of being at risk}
\usage{
patrisk(
  time = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda = NA_real_,
  gamma = 0L
)
}
\arguments{
\item{time}{A vector of analysis times at which to calculate the
probability of being at risk.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}

\item{gamma}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout. Defaults to 0 for no dropout.}
}
\value{
A vector of probabilities of being at risk at the specified
analysis times after enrollment for a patient in a treatment group with
specified piecewise exponential survival and dropout distributions.
}
\description{
Obtains the probability of being at risk at given analysis
times.
}
\examples{
# Piecewise exponential survival with hazard 0.0533 in the first 6 months,
# and hazard 0.0309 thereafter, and 5\% dropout by the end of 1 year.

patrisk(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
        lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
