% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignANOVA}
\alias{getDesignANOVA}
\title{Power and sample size for one-way ANOVA}
\usage{
getDesignANOVA(
  beta = NA_real_,
  n = NA_real_,
  ngroups = 2,
  means = NA_real_,
  stDev = 1,
  allocationRatioPlanned = NA_real_,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{means}{The treatment group means.}

\item{stDev}{The common standard deviation.}

\item{allocationRatioPlanned}{Allocation ratio for the treatment
groups. It has length \code{ngroups - 1} or \code{ngroups}. If it is
of length \code{ngroups - 1}, then the last treatment group will
assume value 1 for allocation ratio.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designANOVA} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis that
there is no difference among the treatment groups.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{means}: The treatment group means.
\item \code{stDev}: The common standard deviation.
\item \code{effectsize}: The effect size.
\item \code{allocationRatioPlanned}: Allocation ratio for the treatment
groups.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power and sample size for one-way
analysis of variance.
}
\details{
Let \eqn{\{\mu_i: i=1,\ldots,k\}} denote the group means, and
\eqn{\{r_i: i=1,\ldots,k\}} denote the randomization probabilities
to the \eqn{k} treatment groups. Let \eqn{\sigma} denote the
common standard deviation, and \eqn{n} denote the total sample
size. Then the \eqn{F}-statistic
\deqn{F = \frac{SSR/(k-1)}{SSE/(n-k)}
\sim F_{k-1, n-k, \lambda},} where
\deqn{\lambda = n \sum_{i=1}^k r_i (\mu_i - \bar{\mu})^2/\sigma^2}
is the noncentrality parameter, and
\eqn{\bar{\mu} = \sum_{i=1}^k r_i \mu_i}.
}
\examples{

(design1 <- getDesignANOVA(
  beta = 0.1, ngroups = 4, means = c(1.5, 2.5, 2, 0),
  stDev = 3.5, allocationRatioPlanned = c(2, 2, 2, 1),
  alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
