\name{triples}
\alias{getTriple}
\alias{setTriple}
\alias{delTriple}
\alias{getSubjectId}
\title{Bind Triples to a Textmatrix}
\description{
  Allows to store, manage and retrieve SPO-triples (subject, predicate, object)
  bound to the document columns of a document term matrix.
}
\usage{
getTriple( M, subject, predicate )
setTriple( M, subject, predicate, object )
delTriple( M, subject, predicate, object )
getSubjectId( M, subject )
}
\arguments{
   \item{M}{the document term matrix (see \code{textmatrix}).}
   \item{subject}{column number or column name (e.g., \code{"doc3"} or \code{3}).}
   \item{predicate}{predicate of the triple sentence (e.g., \code{"has\_category"} or \code{"has\_grade"}).}
   \item{object}{value of the triple sentence (e.g., \code{"14"} or \code{14}).}
}
\details{
  
  SPO-Triples are simple facts of the uniform structure
  (subject, predicate, object). A subject is typically
  a document in the given document-term matrix M,
  i.e. its document title (as in the column names) or its 
  column position. A key-value pair (the \option{predicate} 
  and the \option{object}) can be bound to this \option{subject}.
  
  This can be used, for example, to store classification
  information about the documents of the text base used.
  
  The triple data is stored in the environment of M
  constructed by \code{textmatrix()}.
  
  Whenever a matrix has to be used which has not been generated by 
  this function, its class should be set to 'textmatrix' and an 
  environment has to be added manually via:
  
  \code{class(mymatrix) = "textmatrix"}
  
  \code{environment(mymatrix) = new.env()}

  Alternatively, \code{as.matrix()} can be used to convert a
  matrix to a textmatrix. To spare memory, the manual method
  might be of advantage.
  
  In \code{getTriple()}, the arguments \option{subject} and \option{predicate}
  are optional.
  
}
\value{
  \item{textmatrix}{the document-term matrix (including row and column names).}
}
\author{ Fridolin Wild \email{fridolin.wild@wu-wien.ac.at} }
\seealso{ \code{\link{textmatrix}} }
\examples{

    x = matrix(2,2,3) # we fake a document term matrix
    rownames(x) = c("dog","mouse") # fake term names
    colnames(x) = c("doc1","doc2","doc3") # fake doc titles
    class(x) = "textmatrix" # usually done by textmatrix()
    environment(x) = new.env() # usually done by textmatrix()
    
    setTriple(x, "doc1", "has_category", "15")
    setTriple(x, "doc2", "has_category", "7")
    setTriple(x, "doc1", "has_grade", "5")
    setTriple(x, "doc1", "has_category", "11")
    
    getTriple(x, "doc1")
    getTriple(x, "doc1")[[2]]
    getTriple(x, "doc1", "has_category") # -> [1] "15" "11"
    
    delTriple(x, "doc1", "has_category", "15")
    getTriple(x, "doc1", "has_category") # -> [1] "11"
    
}
\keyword{array}
