% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akmeans.R
\name{akmeans}
\alias{akmeans}
\title{K-Means Over One Way of An Three-Way Array}
\usage{
akmeans(data, centers, margin = 3L, ndim = NULL, ...)
}
\arguments{
\item{data}{Three-way data array}

\item{centers}{Passed to \code{\link{kmeans}}}

\item{margin}{Integer indicating which way to cluster over}

\item{ndim}{The rank of the low dimensional approximation of the matrix
slices to construct before clustering (using \code{\link{svd}})}

\item{\dots}{Additional arguments passed to \code{\link{kmeans}}}
}
\description{
Vectorize matrix slices over a specific way of an three-way array, and
conduct \code{\link{kmeans}} on it.
}
\examples{
set.seed(1)
res <- akmeans(data = carray(dcars), margin = 3L, centers = 5, nstart = 10)
}
