% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirm2pl_normal.R
\name{lsirm2pl_normal}
\alias{lsirm2pl_normal}
\title{2pl LSIRM model with normal likelihood}
\usage{
lsirm2pl_normal(
  data,
  spikenslab = FALSE,
  fixed_gamma = FALSE,
  missing_data = NA,
  ...
)
}
\arguments{
\item{data}{Matrix; binary item response matrix to be analyzed. Each row is assumed to be respondent and its column values are assumed to be response to the corresponding item.}

\item{spikenslab}{Whether to use a model selection approach.}

\item{fixed_gamma}{Whether fix gamma to 1.}

\item{missing_data}{The assumed missing type. One of NA, "mar" and "mcar". Default uses NA.}

\item{...}{Additional arguments for the corresponding function.}
}
\value{
\code{lsirm2pl_normal} returns an object of list. See corresponding function.
}
\description{
\link{lsirm2pl_normal} integrates all functions related to 2pl LSIRM with normal likelihood.
}
\note{
If both \code{spikenslab} and \code{fixed_gamma} are set \code{TRUE}, it returns error because both are related to \code{gamma}.
}
\seealso{
\code{\link{lsirm2pl_normal_o}}, \code{\link{lsirm2pl_normal_fixed_gamma}}, \code{\link{lsirm2pl_normal_mar}},

\code{\link{lsirm2pl_normal_mcar}},\code{\link{lsirm2pl_normal_fixed_gamma_mar}}, \code{\link{lsirm2pl_normal_fixed_gamma_mcar}},
    
\code{\link{lsirm2pl_normal_ss}}, \code{\link{lsirm2pl_normal_mar_ss}}, \code{\link{lsirm2pl_normal_mcar_ss}}
}
