% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associationTest.R
\name{associationTest}
\alias{associationTest}
\title{Chi-square test of association / independence}
\usage{
associationTest(formula, data = NULL)
}
\arguments{
\item{formula}{One-sided formula specifying the two variables (required).}

\item{data}{Optional data frame containing the variables.}
}
\value{
An object of class 'assocTest'. When printed, the output is
organised into six short sections. The first section lists the name
of the test and the variables included. The second lists the null and
alternative hypotheses for the test. The third shows the observed
contingency table, and the fourth shows the expected contingency
table under the null. The fifth prints out the test results, and the
sixth reports an estimate of effect size.
}
\description{
Convenience function that runs a chi-square test of
association/independence. This is a wrapper function intended to
be used for pedagogical purposes only.
}
\details{
The \code{associationTest} function runs the chi-square test
of association on the variables specified in the \code{formula} argument.
The formula must be a one-sided formula of the form
\code{~variable1 + variable2}, and both variables must be factors.
}
\examples{
df <- data.frame(
gender=factor(c("male","male","male","male","female","female","female")),
answer=factor(c("heads","heads","heads","heads","tails","tails","heads"))
)

associationTest( ~ gender + answer, df )

}
