# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'Fast C++ implementation of agreement vector for the element-wise comparison of 2 matrices
#'
#'@param mat_A a \code{nB x K} matrix of the observations to be matched. Must be integers.
#'
#'@param mat_B a \code{nA x K} matrix of the database into which a match is looked for. Must be integers.
#'
#'@aliases agree_C_sparse agree_C
#'
#'@examples
#'mat1 <- matrix(round(rnorm(n=1000, sd=1.2)), ncol=10, nrow=100)
#'mat2 <- rbind(mat1[1:10, ],
#'              matrix(round(rnorm(n=900, sd=1.2)), ncol=10, nrow=90)
#'              )
#'rownames(mat1) <- paste0("A", 1:nrow(mat1))
#'rownames(mat1) <- paste0("B", 1:nrow(mat1))
#'mat1 <- 1*(mat1>1)
#'mat2 <- 1*(mat2>1)
#'
#'@export
agree_C <- function(mat_A, mat_B) {
    .Call(`_ludic_agree_C`, mat_A, mat_B)
}

#'@rdname agree_C
#'
#'@description \code{agree_C_sparse} uses sparse matrices.
#'
#'@export
agree_C_sparse <- function(mat_A, mat_B) {
    .Call(`_ludic_agree_C_sparse`, mat_A, mat_B)
}

#'Fast C++ implementation of Winkler's Method E step
#'
#'@keywords internal
estep_C_vect <- function(agreemat, p, m, u) {
    .Call(`_ludic_estep_C_vect`, agreemat, p, m, u)
}

#'C++ implementation of the E and M steps from Winkler's EM algorithm estimating FS method 
#'using sparse matrices for big sample sizes
#'
#'@keywords internal
EMstep_C_sparse_big <- function(mat_A, mat_B, p, m, u) {
    .Call(`_ludic_EMstep_C_sparse_big`, mat_A, mat_B, p, m, u)
}

#'C++ implementation of the pseudo-likelihood computation 
#'
#'@param Bmat \code{K x nB} matrix of the observations to be matched.
#'
#'@param Amat \code{nA x K} matrix the database into which a match is looked for.
#'
#'@param eps_p a vector of length \code{K} giving the prior discrepancy rate 
#'expected from A to B for the positives, for each variable.
#'
#'@param eps_n a vector of length \code{K} giving the prior discrepancy rate 
#'expected from A to B for the negatives, for each variable.
#'
#'@param piA a vector of length \code{K} giving the prior probabilities of 
#'observing each variable in A.
#'
#'@param piB a vector of length \code{K} giving the prior probabilities of 
#'observing each variable in B.
#'
#'@rdname loglikC_bin
#'
#'@description \code{loglikC_bin} implements an even faster C++ implementation of the pseudo-likelihood computation for binary
#'variables
#'
#'@export
loglikC_bin <- function(Bmat, Amat, eps_p, eps_n, piA, piB) {
    .Call(`_ludic_loglikC_bin`, Bmat, Amat, eps_p, eps_n, piA, piB)
}

#'Splitting a character string in C++
#' 
#'@param s a character string to be split
#'
#'@param sep a character that delimits the splits
#' 
#'@keywords internal
#' 
#'@examples
#'strsplitC(c(";aaa;bb;cccc;ee;"), sep=";")
#'@export
strsplitC <- function(s, sep) {
    .Call(`_ludic_strsplitC`, s, sep)
}

#'@rdname loglikC_bin
#'
#'@description \code{loglikC_bin_wDates} implements a C++ implementation of the pseudo-likelihood computation for binary
#'variables with dates
#'
#'@param Bdates \code{nB x K} matrix of the dates for each observations to be matched.
#'
#'@param Adates \code{nA x K} matrix of the dates for database into which a match is looked for.
#'
#'@export
loglikC_bin_wDates <- function(Bmat, Amat, Bdates, Adates, eps_p, eps_n, piA, piB) {
    .Call(`_ludic_loglikC_bin_wDates`, Bmat, Amat, Bdates, Adates, eps_p, eps_n, piA, piB)
}

#'Fast C++ implementation of the log-likelihood ratio computation for 
#'differentiating variables
#'
#'@param d_max a numeric vector of length \code{K} giving the minimum difference 
#'from which it is considered a discrepancy.
#'
#'@param cost a numeric vector of length \code{K} giving the arbitrary cost of discrepancy.
#'
#'@rdname loglikC_bin
#'
#'@export
loglikratioC_diff_arbitrary <- function(Bmat, Amat, d_max, cost) {
    .Call(`_ludic_loglikratioC_diff_arbitrary`, Bmat, Amat, d_max, cost)
}

#'Compute the matching probabilities for each pair of observations
#'
#'C++ version: for each observations in \code{(1:n)}, all the matching probabilities are computed
#'for the \code{p} possible pairs.
#'
#'@param computed_dist a \code{n x p} matrix of computed distances used for ranking.
#'@param prop_match a priori proportion of matches ("rho_1")
#'
#'@return a \code{n x p} matrix containing the matching probabilities for each pair
#'
#'@export
matchProbs_rank_full_C <- function(computed_dist, prop_match) {
    .Call(`_ludic_matchProbs_rank_full_C`, computed_dist, prop_match)
}

#'Fast C++ computation of the final posterior probabilities in the E-M Winkler's method
#'
#'@param agreemat binary sparse matrix of dimensions \code{N x K} containing the agreement rows for each pair of potential matches.
#'@param m vector of length \code{K} containing the agreement weights.
#'@param u vector of length \code{K} containing the disagreement weights.
#'@param nA integer indicating the number of observations to be matched.
#'@param nB integer indicating the number of observations to be matched with.
#'
#'@export
matchingScore_C <- function(agreemat, m, u, nA, nB) {
    .Call(`_ludic_matchingScore_C`, agreemat, m, u, nA, nB)
}

#'@rdname matchingScore_C
#'@param mat_A a \code{nB x K} matrix of the observations to be matched.
#'@param mat_B a \code{nA x K} matrix of the database into which a match is looked for.
#'@description \code{matchingScore_C_sparse_big} implements a version using sparse matrices. It has a better 
#'management of memory but is a little bit slower (indicated for big matrices)
#'@export
matchingScore_C_sparse_big <- function(mat_A, mat_B, m, u) {
    .Call(`_ludic_matchingScore_C_sparse_big`, mat_A, mat_B, m, u)
}

