% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_cha}
\alias{check_cha}
\title{check_cha}
\usage{
check_cha(col, df, verbose = TRUE)
}
\arguments{
\item{col}{a character variable name}

\item{df}{a data.frame}

\item{verbose}{logical, controlling the output}
}
\value{
a distribution table of the character variable in the data frame
}
\description{
Check for missing values for character columns
}
\details{
This function is used to check the distribution of character variables in the data frame.
}
\examples{
\donttest{
data("melanoma", package = "boot")
melanoma2 <- melanoma
check_cha('status', melanoma2)
# or
mapply(check_cha,'status', MoreArgs= list(melanoma2))
}
}
\author{
Zhen Lu
}
