% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpVarRasterList.R
\docType{methods}
\name{ExpVarRasterList}
\alias{ExpVarRasterList}
\alias{ExpVarRasterList,missing-method}
\alias{ExpVarRasterList,missing,character-method}
\alias{ExpVarRasterList,character-method}
\alias{ExpVarRasterList,character,character-method}
\alias{ExpVarRasterList,RasterStack-method}
\alias{ExpVarRasterList,RasterStack,character-method}
\alias{ExpVarRasterList,list-method}
\alias{ExpVarRasterList,list,character-method}
\title{Create an ExpVarRasterList object}
\usage{
ExpVarRasterList(x, ...)

\S4method{ExpVarRasterList}{missing}(x, pattern = NULL, ...)

\S4method{ExpVarRasterList}{character}(x, pattern = NULL, ...)

\S4method{ExpVarRasterList}{RasterStack}(x, pattern = NULL, ...)

\S4method{ExpVarRasterList}{list}(x, pattern = NULL, ...)
}
\arguments{
\item{x}{path (character) to directory containing observed land use maps,
a Raster* object or a list of Raster* objects}

\item{\dots}{additional arguments to \code{raster::\link[raster]{stack}}}

\item{pattern}{regular expression (character). Only filenames (if \code{x} is
a path) or Raster* objects (if \code{x} is a list) matching the regular
expression will be returned. See \cr
\code{raster::\link[raster]{raster}} for more information about supported
filetypes}
}
\value{
An ExpVarRasterList object.
}
\description{
Methods to load maps of explanatory variables, which may be created from file,
an existing Raster* object or a list of Raster* objects.
}
\details{
Explanatory variables should follow a naming convention to identify them as
static (one map provided for the study period) or dynamic (one map provided
for each year of the study period). The name should consist of two (static)
or three (dynamic) parts: firstly, the prefix should differentiate explanatory
variables from other maps in the directory, list or RasterStack. This should
be followed by a unique number to differentiate the explanatory variables
(note that the order of variables in the ExpVarRasterList object is determined by
this value) If the variable is dynamic this number should be followed by a
second number representing the timestep to which the map applies. Dynamic
variables should include a map for time 0 (corresponding to the initial
observed map) and every subsequent timestep in the simulation. The different
parts should be separated by a period or underscore.

Maps of different explanatory variables should have the same coordinate
reference system but do not have to have the same extent and resolution as
long as the minimum extent is that of the study region defined by an
\code{ObsLulcRasterStack} object. However, maps for different timesteps of the same
dynamic variable should have the same extent and resolution because these are
stored as RasterStack objects.
}
\examples{

## Plum Island Ecosystems
ef <- ExpVarRasterList(x=pie, pattern="ef")

## Sibuyan
ef <- ExpVarRasterList(x=sibuyan$maps, pattern="ef")

}
\seealso{
\code{raster::\link[raster]{stack}}
}
