% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geod.R
\name{geod}
\alias{geod}
\alias{st_geod_area}
\alias{st_geod_length}
\alias{st_geod_segmentize}
\alias{st_geod_covers}
\alias{st_geod_covered_by}
\alias{st_geod_distance}
\title{liblwgeom geodetic functions}
\usage{
st_geod_area(x)

st_geod_length(x)

st_geod_segmentize(x, max_seg_length)

st_geod_covers(x, y, sparse = TRUE)

st_geod_covered_by(x, y, sparse = TRUE)

st_geod_distance(x, y, tolerance = 0, sparse = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{max_seg_length}{segment length in degree, radians, or as a length unit (e.g., m)}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{sparse}{logical; if \code{TRUE}, return a sparse matrix (object of class \code{sgbp}), otherwise, return a dense logical matrix.}

\item{tolerance}{double or length \code{units} value: if positive, the first distance less than \code{tolerance} is returned, rather than the true distance}
}
\description{
liblwgeom geodetic functions for length, area, segmentizing, covers
}
\details{
\code{st_area} will give an error message when the area spans the equator and \code{lwgeom} is linked to a proj.4 version older than 4.9.0 (see \link{lwgeom_extSoftVersion})

longitude coordinates returned are rescaled to [-180,180)
}
\note{
this function should is used by \link[sf]{st_distance}, do not use it directly
}
\examples{
library(sf)
nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
st_geod_area(nc[1:3,])
# st_area(nc[1:3,])
l = st_sfc(st_linestring(rbind(c(7,52), c(8,53))), crs = 4326)
st_geod_length(l)
library(units)
pol = st_polygon(list(rbind(c(0,0), c(0,60), c(60,60), c(0,0))))
x = st_sfc(pol, crs = 4326)
seg = st_geod_segmentize(x[1], set_units(10, km))
plot(seg, graticule = TRUE, axes = TRUE)
pole = st_polygon(list(rbind(c(0,80), c(120,80), c(240,80), c(0,80))))
pt = st_point(c(0,90))
x = st_sfc(pole, pt, crs = 4326)
st_geod_covers(x[c(1,1,1)], x[c(2,2,2,2)])
pole = st_polygon(list(rbind(c(0,80), c(120,80), c(240,80), c(0,80))))
pt = st_point(c(30,70))
x = st_sfc(pole, pt, crs = 4326)
st_geod_distance(x, x)
}
