% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2.R
\name{m2_call}
\alias{m2_call}
\alias{m2r_version_number}
\alias{start_m2}
\alias{stop_m2}
\alias{reset_m2}
\alias{m2}
\alias{m2.}
\alias{print.m2_pointer}
\title{Call and reset a Macaulay2 process}
\usage{
m2r_version_number()

start_m2(port = 27436L, timeout = 10, attempts = 10, cloud = FALSE,
  hostname = m2r_cloud_url())

stop_m2()

reset_m2(port = 27436L, timeout = 10, attempts = 10,
  hostname = "ec2-52-10-66-241.us-west-2.compute.amazonaws.com")

m2(code, timeout = -1)

m2.(code, timeout = -1)

\method{print}{m2_pointer}(x, ...)
}
\arguments{
\item{port}{port for Macaulay2 socket}

\item{timeout}{number of seconds before aborting}

\item{attempts}{numer of times to try to make connection}

\item{cloud}{use a cloud?}

\item{hostname}{the remote host to connect to; defaults to
the Amazon EC2 instance}

\item{code}{Macaulay2 code}

\item{x}{formal argument for print method}

\item{...}{...}
}
\value{
m2 return value
}
\description{
Call and reset a Macaulay2 process
}
\examples{

\dontrun{ requires Macaulay2

m2("1 + 1")
m2.("1 + 1")

m2("factor 32004")

# run a chunk of m2 code, only pulling the end value back into R
m2("
  R = QQ[a..d]
  I = ideal(a^3-b^2*c, b*c^2-c*d^2, c^3)
  G = gens gb I
")

# illustrate the persistent connection
m2("a = 1 + 1")
m2("a")
reset_m2()
m2("a")



m2.("peek(QQ[x,y,z])")
m2("peek(QQ[x,y,z])")

# m2 returns in its ext_str position the result of running
# toExternalString on the return value of the chunk of code
# you run. in principle, toExternalString provides the code
# needed to recreate the m2 object of interest. however,
# does not work for all objects represtable in the m2 language.
# in particular, mutable objects are not supported.
# this is what happens when you look at those:
m2.("new MutableList from {1,2,3}")
m2("new MutableList from {1,2,3}")

}
}
