% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snf.R
\name{snf}
\alias{snf}
\alias{snf.}
\title{Smith normal form}
\usage{
snf(mat, code = FALSE)

snf.(mat, code = FALSE)
}
\arguments{
\item{mat}{a matrix (integer entries)}

\item{code}{return only the M2 code? (default: \code{FALSE})}
}
\value{
a list of integer matrices D, P, and Q
}
\description{
For an integer matrix M, this computes the matrices D, P, and Q
such that \emph{D = PMQ}, which can be seen as an analogue of the
singular value decomposition. All are integer matrices, and P and
Q are unimodular (have determinants +- 1).
}
\examples{

\dontrun{ requires Macaulay2

##### basic usage
########################################

M <- matrix(c(
   2,  4,   4,
  -6,  6,  12,
  10, -4, -16
), nrow = 3, byrow = TRUE)

snf(M)

(mats <- snf(M))
P <- mats$P; D <- mats$D; Q <- mats$Q

P \%*\% M \%*\% Q                # = D
solve(P) \%*\% D \%*\% solve(Q)  # = M

det(P)
det(Q)


M <- matrix(c(
     1,    2,    3,
     1,   34,   45,
  2213, 1123, 6543,
     0,    0,    0
), nrow = 4, byrow = TRUE)
(mats <- snf(M))
P <- mats$P; D <- mats$D; Q <- mats$Q
P \%*\% M \%*\% Q                # = D


##### other options
########################################

snf.(M)
snf(M, code = TRUE)




}

}
