% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLL.R
\name{LLL}
\alias{LLL}
\alias{LLL.}
\title{LLL algorithm}
\usage{
LLL(mat, control = list(), code = FALSE)

LLL.(mat, control = list(), code = FALSE)
}
\arguments{
\item{mat}{a matrix (integer entries)}

\item{control}{additional arguments to pass to LLL; see examples}

\item{code}{return only the M2 code? (default: \code{FALSE})}
}
\value{
an object of class \code{m2_matrix}
}
\description{
Macaulay2's implementation of the LLL algorithm. This implementation is still
under development and is currently untested.
}
\examples{

\dontrun{ requires Macaulay2

##### basic usage
########################################

# example 1
M <- matrix(c(
  1, 1, 1, 1,
  2, 0, 3, 4,
  1, 0, 0, 0,
  0, 1, 0, 0,
  0, 0, 1, 0,
  0, 0, 0, 1
), nrow = 6, byrow = TRUE)

LLL(M)




# example 2 (wikipedia)
M <- matrix(c(
  1, -1, 3,
  1,  0, 5,
  1,  2, 6
), nrow = 3, byrow = TRUE)

LLL(M)


##### control
########################################

M <- matrix(c(
  1, 1, 1, 1,
  2, 0, 3, 4,
  1, 0, 0, 0,
  0, 1, 0, 0,
  0, 0, 1, 0,
  0, 0, 0, 1
), nrow = 6, byrow = TRUE)

LLL(M, code = TRUE)
LLL(M, control = list(Strategy = "NTL"), code = TRUE)
LLL(M, control = list(Strategy = c("BKZ", "RealFP")), code = TRUE)

LLL(M)
LLL(M, control = list(Strategy = "NTL"))
LLL(M, control = list(Strategy = c("BKZ", "RealFP")))
LLL(M, control = list(Strategy = c("BKZ", "RealQP")))



# method timings with microbenchmark.  note they are roughly the same
# for this example matrix
microbenchmark::microbenchmark(
  "NTL" = LLL(M, control = list(Strategy = "NTL")),
  "BKZ_RealFP" = LLL(M, control = list(Strategy = c("BKZ", "RealFP"))),
  "BKZ_RealQP" = LLL(M, control = list(Strategy = c("BKZ", "RealQP"))),
  "BKZ_RealRR" = LLL(M, control = list(Strategy = c("BKZ", "RealRR")))
)



##### additional examples
########################################

LLL.(M)
LLL(M, code = TRUE)



}

}
\seealso{
\code{\link[=m2_matrix]{m2_matrix()}}
}
