% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename-mailbox.R
\name{rename_mailbox}
\alias{rename_mailbox}
\title{Rename Mailbox}
\usage{
rename_mailbox(imapconf, new_name, reselect_mbox = TRUE, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\code{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{new_name}{A string containing the new name to be set.}

\item{reselect_mbox}{If \code{TRUE}, calls \code{select_mailbox(mbox = to_mbox)}
before returning the output. Default is \code{FALSE} for moving and
copying operations, whereas it is \code{TRUE} for renaming mailboxes.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
An (invisible) \code{imaconf} object with the newer selected mailbox added
    to it. If \code{reselect_mbox} is \code{FALSE}, it returns the
    \code{imaconf} object with the former mailbox name.
}
\description{
Rename a mailbox.
}
\examples{
\dontrun{

# configure IMAP
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                          username="your_gmail_user",
                          password=rstudioapi::askForPassword()
                          )

# rename mailbox "Sent"
imapconf \%>\%
  select_mailbox(mbox = "Sent") \%>\%
  rename_mailbox(new_name = "Sent Mail")

}
}
\seealso{
Other mailbox commands: \code{\link{examine_mailbox}},
  \code{\link{list_mailboxes}},
  \code{\link{list_server_capabilities}},
  \code{\link{select_mailbox}}
}
\concept{mailbox commands}
