% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-sent-period.R
\name{search_sent_period}
\alias{search_sent_period}
\title{Search By Origination (RC-2822 Header) Date}
\usage{
search_sent_period(imapconf, since_date_char, before_date_char,
  negate = FALSE, by = "MSN", flag = NULL, esearch = FALSE,
  return_imapconf = TRUE, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{since_date_char}{A character vector with format "DD-Mon-YYYY",
e.g. "01-Apr-2019" indicating the start date (inclusive). We opted not to
use objects of type "date", since IMAP servers like this not so common date
format.}

\item{before_date_char}{A character vector with format "DD-Mon-YYYY",
e.g. "01-Apr-2019" indicating the stop date (exclusive). We opted not to
use objects of type "date", since IMAP server likes this not so common date
format.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{flag}{Optional parameter that adds a flag filter to the search. Use
\link{flag_options} to list the common flags used by IMAP servers.
Default is \code{NULL}.}

\item{esearch}{A logical. Default is \code{FALSE}. If the IMAP server has
\code{ESEARCH} capability, it can be used to optimize search results. It
allows to condense results to message sets to cut down on transmission
costs, e.g. \code{1:5} instead of writing ids individually such as
\code{1,2,3,4,5}. It can be used along with buffersize to avoid results
stripping. Check if your IMAP server supports \code{SEARCH} with
\code{\link{list_server_capabilities}}.}

\item{return_imapconf}{A logical. If \code{TRUE}, the function returns a
\code{list} of length \code{2}, containing the \code{imapconf} object
(IMAP settings) and the search results as message ids (\code{"MSN"} or
\code{"UID"}). If \code{FALSE}, returns only the message ids as a numeric
vector. Default is \code{TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
Depending on the \code{return_imapconf} parameter, it can be a
    \code{list} of length \code{2} containing the \code{imapconf} object
    and message ids resulted from search, or a numeric vector containing
    only message ids.
}
\description{
Functions that allows searching for messages using the
    (RC-2822 Header) date criteria, such as before, since, on, and period.
}
\note{
\link{search_before}, \link{search_since}, \link{search_on}, and
    \link{search_period} use internal date,
    which reflects the moment when the message was received.
    \link{search_sent_before}, \link{search_sent_since}, \link{search_sent_on}, and
    \link{search_sent_period} use RFC-2822 date header (origination date), which
    "specifies the date and time at which the creator of the message
    indicated that the message was complete and ready to enter the mail
    delivery system" (Resnick, 2008). Dates in both methods must be the same
    most of time. Nonetheless, using internal date for search is faster
    (Babcock, 2016).
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# search
results <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    search_sent_period(since_date_char = "17-Apr-2012",
                 before_date_char = "30-Jun-2015",
                 flag = "UNFLAGGED")

}

}
\references{
Resnick, P., "Internet Message Format", RFC 5322, October 2008.

Babcock, N., "Introduction to IMAP", Blog, May 2016.
}
\seealso{
Other Date-search operations: \code{\link{custom_search}},
  \code{\link{search_before}}, \code{\link{search_on}},
  \code{\link{search_period}},
  \code{\link{search_sent_before}},
  \code{\link{search_sent_on}},
  \code{\link{search_sent_since}},
  \code{\link{search_since}}
}
\concept{Date-search operations}
