% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/before.R
\name{before}
\alias{before}
\title{Criterion constructor function to be combined in a custom search statement}
\usage{
before(date_char, negate = FALSE)
}
\arguments{
\item{date_char}{A \code{character string} with format "DD-Mon-YYYY", e.g.
"01-Apr-2019". We opt not to use \code{Date} or \code{POSIX*} like
objects, since IMAP servers use this unusual date format.}

\item{negate}{If \code{TRUE}, negates the search and seeks for "NOT SEARCH
CRITERIA". Default is \code{FALSE}.}
}
\value{
A search string to be used as a \code{request} parameter in
 \code{ImapCon$search()} function.
}
\description{
Criterion constructor function to be combined in a custom search statement
}
\examples{
\dontrun{
# select folder & search
con$select_folder(name = "INBOX")
# search for messages BEFORE "17-Apr-2019" AND NOT SMALLER than 512KB.
res <- con$search(request = AND(before(date_char = "17-Apr-2019"),
                                smaller_than(size = 512000, negate = TRUE)))
}
}
\seealso{
Other custom search: 
\code{\link{AND}()},
\code{\link{ImapCon}},
\code{\link{OR}()},
\code{\link{flag}()},
\code{\link{larger_than}()},
\code{\link{older_than}()},
\code{\link{on}()},
\code{\link{sent_before}()},
\code{\link{sent_on}()},
\code{\link{sent_since}()},
\code{\link{since}()},
\code{\link{smaller_than}()},
\code{\link{string}()},
\code{\link{younger_than}()}
}
\concept{custom search}
