% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabOdds.R
\name{tabOdds}
\alias{tabOdds}
\title{Calculating Odds}
\usage{
tabOdds(
  data,
  ...,
  by,
  exp_value = NULL,
  case_value = NULL,
  plot = TRUE,
  na.rm = FALSE,
  rnd = 3
)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{exp_value}{value for exposure as reference}

\item{case_value}{value for outcome as reference}

\item{plot}{logical value to display plots of rates across a categorical
variable}

\item{na.rm}{A logical value to specify missing values, \code{NA} in the table}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\description{
\code{tabOdds} generates cross-tabulation between two variables and
display odds of failure \code{var_case} among exposure variable
\code{var_exp}. It is used in case-control studies.
}
\details{
A table tabulating odds and corresponding 95\\% confidence interval
is generated.

\strong{Formula for calculating Odds}

\deqn{OR = d1 x h0 / d0 x h1}

\strong{Error Factor} (EF)

\deqn{EF = exp(1.96 x SE(log odds))}

\deqn{SE(log odds) = \sqrt{1/d + 1/h}}
}
\examples{

## use infert data
data(infert)

tabOdds(infert, education, by = case, plot = FALSE)

}
\references{
\enumerate{
\item  Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
\item B. Burt Gerstman (2013, ISBN:978-1-4443-3608-5)
\item Douglas G Altman (2005, ISBN:0 7279 1375 1)
}
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
