% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate-copula.r
\name{copula2d}
\alias{copula2d}
\alias{d2dcop.asym}
\alias{p2dcop.asym}
\alias{r2dcop.asym}
\alias{dcopula}
\alias{pcopula}
\alias{rcopula}
\title{Some Bivariate Copulas}
\usage{
d2dcop.asym(u, v, lambda, copula = "clayton", ...)

p2dcop.asym(u, v, lambda, copula = "clayton", ...)

r2dcop.asym(n, lambda, copula = "clayton", ...)

dcopula(u, v, copula, ...)

pcopula(u, v, copula, ...)

rcopula(n, copula, ...)
}
\arguments{
\item{u, v}{vectors of same length at which the copula and its density is evaluated}

\item{lambda}{a vector of three mixing proportions which sum to one}

\item{copula}{the name of a copula to be called or a base copula for 
construncting asymmetric copula(see Details)}

\item{...}{the parameter(s) of \code{copula}, \code{theta} for most of the models, and
\code{df}, the degrees of freedom if \code{copula='t'}, or \code{m} if \code{copula='nakagami'}}

\item{n}{number of random vectors to be generated}
}
\value{
a vector of copula ot its density values evaluated at \code{(u,v)} 
    or an \code{n x 2} matrix of the generated observations
}
\description{
Parametric bivariate copulas,  densities, and random number generators
}
\details{
The names of available copulas are \code{'amh'} (Ali-Mikhai-Haq), \code{'bern'} (Bernstein polynomial model),
  \code{'clayton'}(Clayton), \code{'exponential'} (Exponential), \code{'fgm'}(Farlie–Gumbel–Morgenstern),
   \code{'frank'} (Frank), \code{'gauss'} (Gaussian), \code{'gumbel'} (Gumbel),
  \code{'indep'} (Independence), \code{'joe'} (Joe), \code{'nakagami'} (Nakagami-m), \code{'plackett'} (Plackett), 
  \code{'t'} (Student's t).
 \code{d2dcop.asym}, etc, calculate the constructive assymmetric copula of Wu (2014)
using base \code{copula} \eqn{C_{\theta}} with mixing proportions \eqn{p=(\lambda_1,\lambda_2,\lambda_3)} and 
  parameter values \eqn{\theta=(\theta_1,\theta_2,\theta_3)}: 
 \eqn{\lambda_0C_{\theta_0}(u,v)+\lambda_1[v-C_{\theta_1}(1-u,v)]+\lambda_2[u-C_{\theta_2}(u,1-v)]}. 
  If \code{copula='t'} or \code{'nakagami'}, \code{df} or \code{m} must be also given.
}
\references{
Nelsen, R. B. (1999). An Introduction to Copulas. Springer Series in Statistics. New York: Springer.
 Wu, S. (2014). Construction of asymmetric copulas and its application 
    in two-dimensional reliability modelling. 
    European Journal of Operational Research 238 (2), 476–485.
}
