% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliKoppen.R
\name{cliKoppenGrid}
\alias{cliKoppenGrid}
\title{Vegetation Classifier Using the KGC System}
\usage{
cliKoppenGrid(rs.temp, rs.prec, verbose = FALSE, filename = "", ...)
}
\arguments{
\item{rs.temp}{multi-layer Raster* object with one-year time series of monthly mean air temperature (in °C)}

\item{rs.prec}{multi-layer Raster* object with one-year time series of monthly precipitation sum (in mm)}

\item{verbose}{'logical' scalar that indicates whether or not values of the bioclimatic indices used should be
added to the output.}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[raster]{writeRaster}}}
}
\value{
Depending on the setting, a RasterStack with one or more layers where the numeric integers encoding the
    KGC type are stored at the last layer, while the additional layers contain the values of bioclimatic indices
    used. The meaning of integers is given in the data frame \code{\link[macroBiome]{vegClsNumCodes}}. If
    \code{verbose = FALSE}, the return object is a single-layer RasterStack with numeric integers encoding the KGC
    type.
}
\description{
Calculates the values of bioclimatic indices used in the Köppen-Geiger classification (KGC) system
    (Köppen 1936), and designates the KGC type using these values, by using the monthly time series of temperature
    and precipitation. The classification scheme is based on the procedure described by Köppen (1936) and follows
    the modifications described by Peel et al. (2007).
}
\details{
See \code{\link[macroBiome]{cliKoppenPoints}}.
}
\note{
The objects \code{'rs.temp'} and \code{'rs.prec'} must be 12-layer Raster* objects. These Raster* objects
    must have the same bounding box, projection, and resolution.
}
\examples{
# Loading mandatory data for the Example 'Climate Normal Grid'
data(inp_exClnrGrid)

# Designate the KGC types (using the related bioclimatic indices)
# for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
rs.KGC <- cliKoppenGrid(temp, prec, verbose = TRUE)
rs.KGC
})

}
\references{
\cite{Köppen W (1936) Das geographische System der Klimate. In: Köppen W, Geiger R (eds) Handbuch der
    Klimatologie. Verlag von Gebrüder Borntraeger, Berlin, Germany, pp 1–44}

\cite{Peel MC, Finlayson BL, McMahon TA (2007) Updated world map of the Köppen-Geiger climate classification.
    Hydrol Earth Syst Sci 11(5):1633–1644. \doi{10.5194/hess-11-1633-2007}}
}
