% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomoments.r
\name{twomoments}
\alias{twomoments}
\title{Estimate the mean and covariance of values.}
\usage{
twomoments(X, diag.only=FALSE, vcov.func=vcov, xtag=NULL, df=NULL)
}
\arguments{
\item{X}{a multidimensional array (or a data frame) of observed values.}

\item{diag.only}{logical flag, defaulting to \code{FALSE}. When
\code{TRUE}, only the diagonal of the covariance is computed, and
returned instead of the entire covariance. This should be used for
reasons of efficiency when only the marginal variances are needed.}

\item{vcov.func}{a function which takes an object of class \code{lm},
and computes a variance-covariance matrix. If equal to the string
"normal", we assume multivariate normal returns.}

\item{xtag}{an optional string tag giving the name of the input data.
defaults to figuring it out from the input expression.}

\item{df}{the number of degrees of freedom to subtract
from the sample size in the denominator of the covariance
matrix estimate. The default value is the number of elements in
the mean, the so-called Bessel's correction.}
}
\value{
A two element list. When \code{diag.only=FALSE}, the first
element of the list is \code{mu}, representing the mean,
a \code{madness} object, the second is \code{Sigma}, representing the covariance,
also a \code{madness} object. When \code{diag.only=TRUE}, the first element
is \code{mu}, but the second is \code{sigmasq}, a \code{madness} object
representing the diagonal of the covariance matrix.
}
\description{
Given rows of observations of some vector (or multidimensional
data), estimates the mean and covariance of the values,
returning two \code{madness} objects. These have a common covariance
and 'xtag', so can be combined together.
}
\details{
Given a 
\eqn{n\times k_1 \times k_2 \times ... \times k_l}{n x k_1 x k_2 ... x k_l}
array whose 'rows' are independent observations of \eqn{X}{X}, computes the 
\eqn{k_1 \times k_2 \times ... \times k_l}{k_1 x k_2 x ... x k_l}
array of the mean of \eqn{X}{X} and the 
\eqn{k_1 \times k_2 \times ... \times k_l \times k_1 \times k_2 ... k_l}{k_1 x k_2 x ... x k_l x k_1 x k_2 ... k_l}
array of the covariance, based on \eqn{n}{n} observations,
returned as two \code{\link{madness}} objects. The variance-covariance
of each is estimated. The two objects have the same 'xtag', and so
may be combined together.
When the \code{diag.only=TRUE}, only the diagonal of the covariance is
computed and returned.

One may use the default method for computing covariance,
via the \code{\link{vcov}} function, or via a 'fancy' estimator,
like \code{sandwich:vcovHAC}, \code{sandwich:vcovHC}, \emph{etc.}
}
\examples{
set.seed(123)
X <- matrix(rnorm(1000*8),ncol=8)
alst <- twomoments(X)
markowitz <- solve(alst$Sigma,alst$mu)
vcov(markowitz)

# now compute the Sharpe ratios:
alst <- twomoments(X,diag.only=TRUE,df=1)
srs <- alst$mu / sqrt(alst$sigmasq)

}
\seealso{
\code{\link{theta}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
