% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-data_evaluate.R
\name{dossier_evaluate}
\alias{dossier_evaluate}
\title{Generate a quality assessment report of a dossier (list of datasets)}
\usage{
dossier_evaluate(dossier, taxonomy = NULL, as_data_dict_mlstr = TRUE)
}
\arguments{
\item{dossier}{List of tibble, each of them being datasets.}

\item{taxonomy}{A tibble identifying the scheme used for variables
classification.}

\item{as_data_dict_mlstr}{Whether the output data dictionary has a simple
data dictionary structure or not (meaning has a Maelstrom data dictionary
structure, compatible with Maelstrom Research ecosystem, including Opal).
TRUE by default.}
}
\value{
A list of tibbles of report for each dataset.
}
\description{
Assesses the content and structure of a dossier object (list of
datasets) and reports possible issues in the datasets and data dictionaries
to facilitate assessment of input data.
The report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.This
report is compatible with Excel and can be exported as an Excel spreadsheet.
}
\details{
A dossier must be a named list containing at least one data frame or
data frame extension (e.g. a tibble), each of them being datasets.
The name of each tibble will be use as the reference name of the dataset.

A taxonomy is classification scheme that can be defined for variable
attributes. If defined, a taxonomy must be a data frame-like object. It must
be compatible with (and is generally extracted from) an Opal environment. To
work with certain functions, a valid taxonomy must contain at least the
columns 'taxonomy', 'vocabulary', and 'terms'. In addition, the taxonomy
may follow Maelstrom research taxonomy, and its content can be evaluated
accordingly, such as naming convention restriction, tagging elements,
or scales, which are specific to Maelstrom Research. In this particular
case, the tibble must also contain 'vocabulary_short', 'taxonomy_scale',
'vocabulary_scale' and 'term_scale' to work with some specific functions.
}
\examples{
{

# use DEMO_files provided by the package
library(dplyr)
library(stringr)

###### Example : a dataset list is a dossier by definition.
dossier_evaluation <- dossier_evaluate(
  DEMO_files[str_detect(names(DEMO_files),"dataset_MELBOURNE")])

glimpse(dossier_evaluation)

}

}
