% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicalSystemModels.R
\name{hes1modelODE}
\alias{hes1modelODE}
\alias{hes1modelDx}
\alias{hes1modelDtheta}
\alias{hes1logmodelODE}
\alias{hes1logmodelDx}
\alias{hes1logmodelDtheta}
\title{Hes1 equations: oscillation of mRNA and protein levels}
\usage{
hes1modelODE(theta, x, tvec)

hes1modelDx(theta, x, tvec)

hes1modelDtheta(theta, x, tvec)

hes1logmodelODE(theta, x, tvec)

hes1logmodelDx(theta, x, tvec)

hes1logmodelDtheta(theta, x, tvec)
}
\arguments{
\item{theta}{vector of parameters.}

\item{x}{matrix of system states (one per column) at the time points in \code{tvec}.}

\item{tvec}{vector of time points}
}
\value{
\code{hes1modelODE} returns an array with the values of the derivatives \eqn{\dot{X}}.

\code{hes1modelDx} returns a 3-D array with the values of the gradients with respect to \eqn{X}.

\code{hes1modelDtheta} returns a 3-D array with the values of the gradients with respect to \eqn{\theta}.

\code{hes1logmodelODE}, \code{hes1logmodelDx}, and \code{hes1logmodelDtheta} are the log-transformed versions of \code{hes1modelODE}, \code{hes1modelDx}, and \code{hes1modelDtheta}, respectively.
}
\description{
The Hes1 equations model the oscillatory cycles of protein and messenger ribonucleic acid (mRNA) levels in cultured cells. The system components \eqn{X = (P, M, H)} represent the concentrations of protein, mRNA, and the Hes1-interacting factor that provides a negative feedback loop.

\eqn{P}, \eqn{M}, and \eqn{H} are governed by the following differential equations:

\deqn{ \frac{dP}{dt} = -aPH + bM - cP }
\deqn{ \frac{dM}{dt} = -d_M M + \frac{e}{1 + P^2} }
\deqn{ \frac{dH}{dt} = -aPH + \frac{f}{1+ P^2} - gH } 

where \eqn{\theta = (a,b,c,d_M,e,f,g)} are system parameters.
}
\examples{
theta <- c(0.022, 0.3, 0.031, 0.028, 0.5, 20, 0.3)
x <- matrix(1:15, nrow = 5, ncol = 3)
tvec <- 1:5

hes1modelODE(theta, x, tvec)

}
\references{
Hirata H, Yoshiura S, Ohtsuka T, Bessho Y, Harada T, Yoshikawa K, Kageyama R (2002). Oscillatory Expression of the bHLH Factor Hes1 Regulated by a Negative Feedback Loop.
\emph{Science}, 298(5594), 840–843.
}
