% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_shade.R
\name{interactive_shade}
\alias{interactive_shade}
\title{interactive shading}
\usage{
interactive_shade(
  image,
  color = FALSE,
  range_max_azimuth,
  range_min_azimuth,
  range_max_elevation,
  range_min_elevation,
  resolution = 0.1,
  return_param = FALSE,
  scale
)
}
\arguments{
\item{image}{a magick image object}

\item{color}{Set to true to shade the red, green, and blue components of the image}

\item{range_max_azimuth}{define maximum in slider of azimuth}

\item{range_min_azimuth}{define maximum in slider of azimuth}

\item{range_max_elevation}{define maximum in slider of elevation}

\item{range_min_elevation}{define maximum in slider of elevation}

\item{resolution}{resolution of slider}

\item{return_param}{If return_param is TRUE, returns values of azimuth and elevation. If return_param is FALSE, returns a magick image object.}

\item{scale}{geometry to be passed to image_scale function of magick package. image is scaled just for preview and result image is not scaled if scale is given.}
}
\value{
a magick image object or values of azimuth and elevation
}
\description{
Using image_shade of 'magick' interactively.
azimuth and elevation are parameters of image_shade. See reference manual of 'magick' for detail.
}
\examples{
\donttest{
interactive_shade(wizard)
}
}
\author{
Shota Ochi
}
