% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{estimate_weights}
\alias{estimate_weights}
\alias{plot.maicplus_estimate_weights}
\title{Derive individual weights in the matching step of MAIC}
\usage{
estimate_weights(
  data,
  centered_colnames = NULL,
  start_val = 0,
  method = "BFGS",
  n_boot_iteration = NULL,
  set_seed_boot = 1234,
  boot_strata = "ARM",
  ...
)

\method{plot}{maicplus_estimate_weights}(
  x,
  ggplot = FALSE,
  bin_col = "#6ECEB2",
  vline_col = "#688CE8",
  main_title = NULL,
  scaled_weights = TRUE,
  bins = 50,
  ...
)
}
\arguments{
\item{data}{a numeric matrix, centered covariates of IPD, no missing value in any cell is allowed}

\item{centered_colnames}{a character or numeric vector (column indicators) of centered covariates}

\item{start_val}{a scalar, the starting value for all coefficients of the propensity score regression}

\item{method}{a string, name of the optimization algorithm (see 'method' argument of \code{base::optim()}) The
default is \code{"BFGS"}, other options are \code{"Nelder-Mead"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}, and \code{"Brent"}}

\item{n_boot_iteration}{an integer, number of bootstrap iterations. By default is NULL which means bootstrapping
procedure will not be triggered, and hence the element \code{"boot"} of output list object will be NULL.}

\item{set_seed_boot}{a scalar, the random seed for conducting the bootstrapping, only relevant if
\code{n_boot_iteration} is not NULL. By default, use seed 1234}

\item{boot_strata}{a character vector of column names in \code{data} that defines the strata for bootstrapping.
This ensures that samples are drawn proportionally from each defined stratum. If \code{NULL},
no stratification during bootstrapping process. By default, it is "ARM"}

\item{...}{Additional \code{control} parameters passed to \link[stats:optim]{stats::optim}.}

\item{x}{object from \link{estimate_weights}}

\item{ggplot}{indicator to print base weights plot or \code{ggplot} weights plot}

\item{bin_col}{a string, color for the bins of histogram}

\item{vline_col}{a string, color for the vertical line in the histogram}

\item{main_title}{title of the plot. For ggplot, name of scaled weights plot and unscaled weights plot, respectively.}

\item{scaled_weights}{(base plot only) an indicator for using scaled weights instead of regular weights}

\item{bins}{(\code{ggplot} only) number of bin parameter to use}
}
\value{
a list with the following 4 elements,
\describe{
\item{data}{a data.frame, includes the input \code{data} with appended column 'weights' and 'scaled_weights'.
Scaled weights has a summation to be the number of rows in \code{data} that has no missing value in any of the
effect modifiers}
\item{centered_colnames}{column names of centered effect modifiers in \code{data}}
\item{nr_missing}{number of rows in \code{data} that has at least 1 missing value in specified centered effect
modifiers}
\item{ess}{effective sample size, square of sum divided by sum of squares}
\item{opt}{R object returned by \code{base::optim()}, for assess convergence and other details}
\item{boot_strata}{'strata' from a boot::boot object}
\item{boot_seed}{column names in \code{data} of the stratification factors}
\item{boot}{a n by 2 by k array or NA, where n equals to number of rows in \code{data}, and k equals
\code{n_boot_iteration}. The 2 columns in the second dimension include a column of numeric indexes of the rows
in \code{data} that are selected at a bootstrapping iteration and a column of weights. \code{boot} is NA when
argument \code{n_boot_iteration} is set as NULL
}
}
}
\description{
Assuming data is properly processed, this function takes individual patient data (IPD) with centered covariates
(effect modifiers and/or prognostic variables) as input, and generates weights for each individual in IPD trial to
match the covariates in aggregate data.

The plot function displays individuals weights with key summary in top right legend that includes
median weight, effective sample size (ESS), and reduction percentage (what percent ESS is reduced from the
original sample size). There are two options of plotting: base R plot and \code{ggplot}. The default
for base R plot is to plot unscaled and scaled separately. The default
for \code{ggplot} is to plot unscaled and scaled weights on a same plot.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(maicplus_estimate_weights)}: Plot method for estimate_weights objects

}}
\examples{
data(centered_ipd_sat)
centered_colnames <- grep("_CENTERED", colnames(centered_ipd_sat), value = TRUE)
weighted_data <- estimate_weights(data = centered_ipd_sat, centered_colnames = centered_colnames)
\donttest{
# To later estimate bootstrap confidence intervals, we calculate the weights
# for the bootstrap samples:
weighted_data_boot <- estimate_weights(
  data = centered_ipd_sat, centered_colnames = centered_colnames, n_boot_iteration = 100
)
}
plot(weighted_sat)

if (requireNamespace("ggplot2")) {
  plot(weighted_sat, ggplot = TRUE)
}
}
