% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{make_prior}
\alias{make_prior}
\title{Making a prior object}
\usage{
make_prior(
  formula,
  data,
  family = "gaussian",
  prior = list(),
  intercept_prior = c(),
  covariate_prior = list()
)
}
\arguments{
\item{formula}{A formula object, using the function \link[makemyprior]{mc}.}

\item{data}{The data used in the model, as a \code{data.frame} or \code{list}. All elements must have the same length.}

\item{family}{A string indicating the likelihood family. \code{gaussian} with identity link is the default.
\code{binomial} with logit link and \code{poisson} with log link are also possible.}

\item{prior}{\describe{
  \item{\code{tree}}{
    The tree structure as a string. A split is specified as \code{s1 = (a,b)}, where \code{(s1)}
    represents a split node and can be any name except names of the input data in \code{data} and
    the reserved \code{(eps)}, which is used for residuals for a Gaussian likelihood. Short names
    are recommended. Note that these split names are just used in the initial specification, and
    will not be used later as they are changed by the function automatically.
    The child nodes for each split are included in parentheses separated by commas, and each
    split is separated by semicolons.
    Singletons are included as \code{(a)}.
  }
  \item{\code{V}}{A named list with information on the priors on each top node and singleton,
  i.e., all variances.
  The names in the list are the top node and singleton names from the \code{tree} argument.
  Syntax is \code{V = list(s1 = list(prior = prior_name, param = parameter_vector))}.}
  \item{\code{w}}{A named list with information on the priors on each split, i.e., all variance proportions.
  The names in the list are the split node names from the \code{tree} argument, and is specified
  in the same way as the variance priors in \code{V}.}
}
Prior on residuals can be defined using \code{eps} in this list in the case of a Gaussian likelihood.}

\item{intercept_prior}{Parameters for Gaussian prior on intercept, specified as a vector with mean and standard deviation.
Default is (0, 1000).}

\item{covariate_prior}{Parameters for Gaussian prior on coefficients of covariates,
specified as named list, each element is a vector with mean and standard deviation. Default is (0, 1000).}
}
\value{
Prior object.
}
\description{
Make a prior object with all necessary information about the prior and model.
The object can either be sent to \link[makemyprior]{makemyprior_gui}
or used directly for inference with Stan (\link[makemyprior]{inference_stan}) or INLA (\link[makemyprior]{inference_inla}).
}
\details{
See \link[makemyprior]{makemyprior_models} for details on available priors and likelihoods.
}
\examples{
\dontrun{

vignette("make_prior", package = "makemyprior")
}

p <- 10
m <- 10
n <- m*p

set.seed(1)
data <- list(a = rep(1:p, each = m),
             b = rep(1:m, times = p),
             x = runif(n))
data$y <- data$x + rnorm(p, 0, 0.5)[data$a] +
  rnorm(m, 0, 0.3)[data$b] + rnorm(n, 0, 1)

formula <- y ~ x + mc(a) + mc(b)

prior <- make_prior(formula, data, family = "gaussian",
                    intercept_prior = c(0, 1000),
                    covariate_prior = list(x = c(0, 100)))
prior
plot(prior)

}
\keyword{prior}
