% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pedigrees_all_populate_autosomal}
\alias{pedigrees_all_populate_autosomal}
\title{Populate 1-locus autosomal DNA profile in pedigrees with single-step mutation model.}
\usage{
pedigrees_all_populate_autosomal(
  pedigrees,
  allele_dist,
  theta,
  mutation_rate,
  progress = TRUE
)
}
\arguments{
\item{pedigrees}{Pedigree list in which to populate genotypes}

\item{allele_dist}{Allele distribution (probabilities) -- gets normalised}

\item{theta}{Theta correction between 0 and 1 (both included)}

\item{mutation_rate}{Mutation rate between 0 and 1 (both included)}

\item{progress}{Show progress}
}
\description{
Populate 1-locus autosomal DNA profile from founder and down in all pedigrees.
Note, that only alleles from ladder is assigned and
that all founders draw type randomly.
}
\details{
Note, that pedigrees must first have been inferred by \code{\link[=build_pedigrees]{build_pedigrees()}}.
}
\seealso{
\code{\link[=pedigrees_all_populate_haplotypes_custom_founders]{pedigrees_all_populate_haplotypes_custom_founders()}} and
\code{\link[=pedigrees_all_populate_haplotypes_ladder_bounded]{pedigrees_all_populate_haplotypes_ladder_bounded()}}.
}
