% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_haplotypes_individuals}
\alias{get_haplotypes_individuals}
\title{Get haplotype matrix from list of individuals}
\usage{
get_haplotypes_individuals(individuals)
}
\arguments{
\item{individuals}{Individuals to get haplotypes for.}
}
\value{
Matrix of haplotypes where row \code{i} is the haplotype of \code{individuals[[i]]}.
}
\description{
Requires that haplotypes are first populated, e.g.
with \code{\link[=pedigrees_all_populate_haplotypes]{pedigrees_all_populate_haplotypes()}},
\code{\link[=pedigrees_all_populate_haplotypes_custom_founders]{pedigrees_all_populate_haplotypes_custom_founders()}}, or
\code{\link[=pedigrees_all_populate_haplotypes_ladder_bounded]{pedigrees_all_populate_haplotypes_ladder_bounded()}}.
}
\examples{
sim <- sample_geneology(100, 10)
peds <- build_pedigrees(sim$population)
pedigrees_all_populate_haplotypes(peds, 2, c(1, 1))
get_haplotypes_individuals(sim$end_generation_individuals)

}
\seealso{
\code{\link[=get_haplotypes_pids]{get_haplotypes_pids()}}.
}
