% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPrevalence.R
\name{convertPrevalence}
\alias{convertPrevalence}
\title{convert prevalences from one age range to another}
\usage{
convertPrevalence(prevalence, age_min_in, age_max_in, age_min_out = rep(2,
  length(prevalence)), age_max_out = rep(9, length(prevalence)),
  parameters = "Pf_Smith2007", sample_weights = NULL)
}
\arguments{
\item{prevalence}{Vector of prevalence values}

\item{age_min_in}{Vector of minimum ages sampled}

\item{age_max_in}{Vector maximum ages sampled.}

\item{age_min_out}{Length 1 numeric or vector of same length as prevalence given the required age range upper bound}

\item{age_max_out}{Length 1 numeric or vector of same length as prevalence given the required age range lower bound}

\item{parameters}{Specifies the set of parameters to use in the
model. This can either be "Pf_Smith2007" to use the parameters
for *Plasmodium falciparum* defined in that paper,
"Pv_Gething2012" for the *P. vivax* parameters used in that paper,
 or a user-specified vector givng the values of parameters `b`,
  `s`, `c` and `alpha`, in that order. If specified,}

\item{sample_weights}{Must be a vector of length 85 giving the
sample weights for each age category (the proportion of the
population in that age category) . If `NULL`, The sample
weights used in Smith et al. 2007 are used.}
}
\description{
convert prevalences from one age range to another
}
\examples{
# Convert from prevalence 2 to 5 to prevalence 2 to 10
pr2_10 <- convertPrevalence(0.1, 2, 5, 2, 10)

# Convert many surveys all to 2 to 10.
pr <- runif(20, 0.1, 0.15)
min_in <- sample(1:5, 20, replace = TRUE)
max_in <- rep(8, 20)
min_out <- rep(2, 20)
max_out <- rep(10, 20)
pr_standardised <- convertPrevalence(pr, min_in, max_in,
                                     min_out, max_out)

plot(pr_standardised, pr)
}
\references{
Smith, D. L. et al. Standardizing estimates of the
  Plasmodium falciparum parasite rate. Malaria Journal 6, 131 (2007).

  Gething, Peter W., et al. "A long neglected world malaria map:
  Plasmodium vivax endemicity in 2010." PLoS neglected tropical
  diseases 6.9 (2012): e1814.


  Code written by Nick Golding and Dave Smith
}
