% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_biotyper_spectra.R
\name{import_biotyper_spectra}
\alias{import_biotyper_spectra}
\title{Importing spectra from the Bruker MALDI Biotyper device}
\usage{
import_biotyper_spectra(
  biotyper_directory,
  remove_calibration = c("BTS", "Autocalibration")
)
}
\arguments{
\item{biotyper_directory}{A path to the folder tree with the spectra to be imported.}

\item{remove_calibration}{A vector of characters used as regex to indicate which (calibration) spectra are going to be removed.}
}
\value{
A list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects
}
\description{
This function is a wrapper around the \code{\link[readBrukerFlexData:readBrukerFlexDir]{readBrukerFlexData::readBrukerFlexDir()}} to read both \code{acqus} and \code{acqu} MALDI files.
}
\details{
When using \code{\link[readBrukerFlexData:readBrukerFlexDir]{readBrukerFlexData::readBrukerFlexDir()}} on \code{acqus} files (instead of the native \code{acqu} files), the function will fail with the following error message:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Error in .readAcquFile(fidFile = fidFile, verbose = verbose) :
File ‘/data/maldi_dir/targetA/0_D10/1/1SLin/acqu’ doesn't exists!
}\if{html}{\out{</div>}}

But it turns out that \code{acqu} and \code{acqus} files \href{https://github.com/sgibb/readBrukerFlexData/wiki/acqu-file}{are the same}, so the function here create \code{acqu} symbolic links that point to \code{acqus} files.
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import the six spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
# Display the list of spectra
spectra_list
}
\seealso{
\link{check_spectra}, \link{process_spectra}
}
