# WARNING - Generated by {fusen} from dev/import-data.Rmd: do not edit by hand

#' Importing a list of Bruker MALDI Biotyper CSV reports
#'
#' @param path_to_reports A vector of paths to the csv files to be imported by [read_biotyper_report()].
#' @param report_ids A vector of character names for each of the reports.
#' @param best_hits A logical indicating whether to return only the best hit in the [read_biotyper_report()] function.
#' @param ... Name-value pairs to be passed on to [dplyr::mutate()]
#'
#' @return A tibble just like the one returned by the [read_biotyper_report()] function, except that the name of the spot of the MALDI target (i.e., plate) is registered to the `original_name` column (instead of the `name` column), and the column `name` consist in the provided `report_ids` used as a prefix of the `original_name` column.
#'
#' @seealso [read_biotyper_report]
#'
#' @note The report identifiers are sanitized to convert all dashes (`-`) as underscores (`_`).
#'
#' @export
#'
#' @examples
#' # List of Bruker MALDI Biotyper reports
#' reports_paths <- system.file(
#'   c("biotyper.csv", "biotyper.csv", "biotyper.csv"),
#'   package = "maldipickr"
#' )
#' # Read the list of reports and combine them in a single tibble
#' read_many_biotyper_reports(
#'   reports_paths,
#'   report_ids = c("first", "second", "third"),
#'   # Additional metadata below are passed to dplyr::mutate
#'   growth_temperature = 37.0
#' )
read_many_biotyper_reports <- function(path_to_reports, report_ids, best_hits = TRUE, ...) {
  # Import the Bruker Biotyper reports as a named list
  # Having name as first column always is to enable
  #  taxonomic identification cherry-picking
  breports <- lapply(
    path_to_reports,
    function(path) {
      read_biotyper_report(path, best_hits) %>%
        dplyr::rename("original_name" = "name")
    }
  )
  names(breports) <- report_ids
  # Conversion of a named list of dataframe to the dataframe with the name as
  #  a column is now super easy with enframe()
  tibble::enframe(breports) %>%
    tidyr::unnest("value") %>%
    dplyr::mutate(
      "name" = paste(gsub("-", "_", .data$name), .data$original_name, sep = "_"),
      ...
    ) %>%
    return()
}
