# WARNING - Generated by {fusen} from dev/dereplicate-spectra.Rmd: do not edit by hand

path_report <- system.file("biotyper_unknown.csv", package = "maldipickr")
report_unknown <- read_biotyper_report(path_report)

test_that("delineate_with_identification fails with path as input", {
  expect_error(
    delineate_with_identification(path_report),
    "Unexpected format of Biotyper report."
  )
})
test_that("delineate_with_identification works with correct single report tibble", {
  expect_message(
    out <- delineate_with_identification(report_unknown),
    "Generating clusters from single report"
  )
  expect_equal(
    nrow(out), 4
  )
  expect_equal(
    out$membership,
    c(2, 3, 1, 1)
  )
})

test_that("delineate_with_identification fails modified single report tibble", {
  expect_error(
    delineate_with_identification(
      report_unknown %>% dplyr::select(!c("name"))
    ),
    "Unexpected format of Biotyper report."
  )
})

report_unknown_no_bh <- read_biotyper_report(path_report, best_hits = FALSE)
test_that("delineate_with_identification WARNS when multiple hits", {
  expect_warning(
    out <- delineate_with_identification(report_unknown_no_bh),
    "There is more than one spectrum identification per target!\n",
  )
  expect_equal(
    nrow(out), 40
  )
  expect_equal(
    out$cluster_size,
    c(
      rep(1, times = 20),
      5, 5, rep(1, times = 8),
      5, 5, 5, rep(1, times = 7)
    )
  )
})


# Artificially generate multiple reports from one
multiple_reports_unknown <- read_many_biotyper_reports(
  rep(path_report, 3),
  report_ids = LETTERS[1:3], best_hits = TRUE
)
test_that("delineate_with_identification works with correct multiple reports tibble", {
  expect_message(
    out <- delineate_with_identification(multiple_reports_unknown),
    "Generating clusters from multiple reports"
  )
  expect_equal(
    nrow(out), 12
  )
  expect_equal(
    out$membership,
    c(2, 3, 1, 1, 4, 5, 1, 1, 6, 7, 1, 1)
  )
})
test_that("delineate_with_identification fails modified tibble for multiple reports", {
  expect_error(
    delineate_with_identification(multiple_reports_unknown %>% dplyr::rename("tax_id" = "bruker_species")),
    "Unexpected format of Biotyper report."
  )
})
