# WARNING - Generated by {fusen} from dev/dereplicate-spectra.Rmd: do not edit by hand

cosine_similarity <- matrix(
  c(
    1, 0.79, 0.77, 0.99, 0.98, 0.98,
    0.79, 1, 0.98, 0.79, 0.8, 0.8,
    0.77, 0.98, 1, 0.77, 0.77, 0.77,
    0.99, 0.79, 0.77, 1, 1, 0.99,
    0.98, 0.8, 0.77, 1, 1, 1,
    0.98, 0.8, 0.77, 0.99, 1, 1
  ),
  nrow = 6,
  dimnames = list(
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    ),
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    )
  )
)
cosine_similarity_toy <- matrix(
  c(1.00, 0.92, 0.80,
    0.92, 1.00, 0.94,
    0.80, 0.94, 1.00),
  nrow = 3, byrow = TRUE,
  dimnames = rep(
    list(c("A", "B", "C")),
    times = 2)
)
test_that("delineate_with_similarity works", {
  expect_equal(
    nrow(delineate_with_similarity(cosine_similarity, 0.92)), 6
  )
  expect_equal(
    delineate_with_similarity(cosine_similarity, 0.92)$membership,
    c(1, 2, 2, 1, 1, 1)
  )
})
test_that("delineate_with_similarity works with different linkage", {
  expect_equal(
    delineate_with_similarity(
      cosine_similarity_toy, 0.92, method = "complete"
    )$membership,
    c(1, 2, 2)
  )
    expect_equal(
    delineate_with_similarity(
      cosine_similarity_toy, 0.92, method = "single"
    )$membership,
    c(1, 1, 1)
  )
})
test_that("delineate_with_similarity fails with wrong input", {
  expect_error(
    delineate_with_similarity(cosine_similarity[, -1], 0.92),
    "not square"
  )
  expect_error(
    delineate_with_similarity(unname(cosine_similarity), 0.92),
    "no rownames or colnames."
  )
  expect_error(
    delineate_with_similarity(cosine_similarity, TRUE),
    "not a numeric"
  )
  expect_error(
    delineate_with_similarity(cosine_similarity, 2.5),
    "not in the range"
  )
  expect_error(
    delineate_with_similarity(cosine_similarity, 0.92, method = "farthest"),
    "invalid clustering method"
  )
})
