/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.CycleException;
import salvo.jesus.graph.DirectedAcyclicGraph;
import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.listener.NullGraphListener;

public class DirectedAcyclicGraphListener
extends NullGraphListener {
    private DirectedAcyclicGraph m_graph;

    public DirectedAcyclicGraphListener(DirectedAcyclicGraph graph) {
        this.m_graph = graph;
        this.m_graph.addListener(this);
    }

    public void beforeEdgeAdded(GraphAddEdgeEvent event) throws Exception {
        DirectedEdge edge = (DirectedEdge)event.getEdge();
        if (event.isAddingVertexA() || event.isAddingVertexB()) {
            return;
        }
        if (this.m_graph.isPath(edge.getSink(), edge.getSource())) {
            throw new CycleException();
        }
    }

    public List getRoot() {
        ArrayList<Vertex> rootVertices = new ArrayList<Vertex>();
        Iterator iterator = this.m_graph.getVerticesIterator();
        while (iterator.hasNext()) {
            Vertex v = (Vertex)iterator.next();
            if (this.m_graph.getIncomingEdges(v).size() != 0) continue;
            rootVertices.add(v);
        }
        return Collections.unmodifiableList(rootVertices);
    }
}

