/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Matrixn;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestMatrixn
extends TestCase {
    public TestMatrixn(String name) {
        super(name);
    }

    public void testIndexing1d() {
        double[] m1 = new double[]{1.0, 2.0, 3.0, 4.0};
        int[] idx1 = new int[1];
        Matrixn a = new Matrixn(m1);
        a.singleToIndices(3, idx1);
        TestMatrixn.assertEquals((int)3, (int)idx1[0]);
        TestMatrixn.assertEquals((int)3, (int)a.singleIndex(idx1));
    }

    public void testIndexing2d() {
        int[] sizes = new int[]{2, 3};
        double[] m1 = new double[6];
        for (int i = 0; i < 6; ++i) {
            m1[i] = 2.0 * (double)i;
        }
        Matrixn a = new Matrixn(sizes, m1);
        int[] idx1 = new int[2];
        a.singleToIndices(5, idx1);
        System.out.println(idx1[0] + " , " + idx1[1]);
        int[] trueIdx = new int[]{1, 2};
        TestMatrixn.assertTrue((boolean)Arrays.equals(trueIdx, idx1));
        TestMatrixn.assertEquals((int)5, (int)a.singleIndex(idx1));
        TestMatrixn.assertEquals((double)10.0, (double)a.value(idx1), (double)1.0E-12);
    }

    public void testIndexing3d() {
        Matrixn a = this.make3dMatrix();
        int[] idx1 = new int[3];
        a.singleToIndices(21, idx1);
        int[] trueIdx = new int[]{1, 2, 1};
        TestMatrixn.assertTrue((boolean)Arrays.equals(trueIdx, idx1));
        TestMatrixn.assertEquals((int)21, (int)a.singleIndex(idx1));
        TestMatrixn.assertEquals((double)42.0, (double)a.value(idx1), (double)1.0E-12);
    }

    private Matrixn make3dMatrix() {
        int[] sizes = new int[]{2, 3, 4};
        double[] m1 = new double[24];
        for (int i = 0; i < 24; ++i) {
            m1[i] = 2.0 * (double)i;
        }
        Matrixn a = new Matrixn(sizes, m1);
        return a;
    }

    public void testMatrixnSerializable() throws IOException, ClassNotFoundException {
        Matrixn a = this.make3dMatrix();
        Matrixn b = (Matrixn)TestSerializable.cloneViaSerialization(a);
        TestMatrixn.assertEquals((int)a.singleSize(), (int)b.singleSize());
        for (int i = 0; i < a.singleSize(); ++i) {
            int[] idxa = new int[a.getNumDimensions()];
            int[] idxb = new int[a.getNumDimensions()];
            a.singleToIndices(i, idxa);
            b.singleToIndices(i, idxb);
            TestMatrixn.assertTrue((boolean)Arrays.equals(idxa, idxb));
            TestMatrixn.assertEquals((double)a.value(idxa), (double)b.value(idxb), (double)1.0E-12);
        }
    }

    public static Test suite() {
        return new TestSuite(TestMatrixn.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestMatrixn(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestMatrixn.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

