% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_sources}
\alias{call_sources}
\title{Call sources for datacubes and datasets in 'many' packages}
\usage{
call_sources(
  package,
  datacube,
  dataset = NULL,
  open_script = FALSE,
  open_codebook = FALSE
)
}
\arguments{
\item{package}{A character vector of package name.
For multiple packages,
please declare package names as a vector (e.g. c("package1", "package2")).}

\item{datacube}{A datacube from one of the many packages.}

\item{dataset}{A dataset in a datacube from one of the many packages.
NULL by default.
That is, all datasets in the datacube are used.
For multiple datasets, please declare datasets as a vector
(e.g. c("dataset1", "dataset2")).}

\item{open_script}{Would you like to open the preparation script
for the dataset?
By default false.}

\item{open_codebook}{Would you like to open the codebook for the dataset?
By default false.}
}
\value{
\code{call_sources} returns a tibble with information on the dataset,
their sources, URL, and mapping to facilitate understanding
variable name changes from original data.
}
\description{
Call sources for datacubes and datasets in 'many' packages
}
\details{
\code{call_sources()} displays sources of the datacubes and datasets
in 'many' packages.
Please declare package, datacube, and dataset
}
\examples{
\donttest{
call_sources("manydata", "emperors")
}
}
\seealso{
Other call_: 
\code{\link{call_packages}()},
\code{\link{call_releases}()},
\code{\link{call_treaties}()}
}
\concept{call_}
