% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_model_1.R
\name{multi_model_1}
\alias{multi_model_1}
\title{Simultaneously train and predict on new data.}
\usage{
multi_model_1(df, yname, xname, method, metric, control, ..., newdata)
}
\arguments{
\item{df}{The data holding the training dataset}

\item{yname}{The outcome variable}

\item{xname}{The predictor variable(s)}

\item{method}{A vector containing methods to be used as defined in the caret package}

\item{metric}{One of several metrics. Accuraciy,RMSE,MAE,etc}

\item{control}{See caret ?trainControl for details.}

\item{...}{Other arguments to caret's train function}

\item{newdata}{A data set to validate the model or for which predictions are required}
}
\value{
A list containing two objects. A tibble containing a summary of the metrics per model
and a tibble containig predicted values
}
\description{
This function provides a convenient way to train several model types.
It allows a user to predict on new data and depending on the  metrics, the user is able to decide which model
predictions to finally use. The models are built based on Max Kuhn's models in the caret package.
}
\details{
Most of the details of the parameters can be found in the caret package documentation.
This function is meant to help in exploratory analysis to
make an informed choice of the best models
}
\examples{
library(caret)
train_set<-createDataPartition(iris$Species,p=0.8,list=FALSE)
valid_set<-iris[-train_set,]
train_set<-iris[train_set,]
ctrl<-trainControl(method="cv",number=5)
set.seed(233)
m<-multi_model_1(train_set,"Species",".",c("knn","rpart"),
                "Accuracy",ctrl,newdata =valid_set)
m$Predictions
m$Metrics
}
\references{
Kuhn (2014), "Futility Analysis in the Cross-Validation of Machine Learning Models" http://arxiv.org/abs/1405.6974,

Kuhn (2008), "Building Predictive Models in R Using the caret" (http://www.jstatsoft.org/article/view/v028i05/v28i05.pdf)
}
