% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_corr.R
\name{get_var_corr}
\alias{get_var_corr}
\title{Get correlations between variables}
\usage{
get_var_corr(df, comparison_var, other_vars = NULL, get_all = TRUE,
  method = "pearson", ...)
}
\arguments{
\item{df}{The data set for which correlations are required}

\item{comparison_var}{The variable to compare to}

\item{other_vars}{Variables for which correlation with comparison_var is required. If not
supplied, all variables will be used.}

\item{get_all}{Logical. Should all variables be used for correlation? If true, all variables
are used. Defaults to TRUE.}

\item{method}{The method used to perform the correlation test as defined in 'cor.test'.
Defaults to pearson.}

\item{...}{Other arguments to 'cor.test' see ?cor.test for details}
}
\value{
A data.frame object containing correlations between comparison_var and each of other_vars
}
\description{
This function returns the correlations between different variables.
}
\examples{
get_var_corr(mtcars, "mpg",get_all = TRUE)
get_var_corr(iris,"Sepal.Length","Petal.Length",get_all = FALSE,method="kendall")
}
