% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_as.R
\name{as}
\alias{as}
\alias{as_edgelist}
\alias{as_matrix}
\alias{as_igraph}
\alias{as_tidygraph}
\alias{as_network}
\alias{as_siena}
\alias{as_graphAM}
\alias{as_diffusion}
\title{Modifying network classes}
\usage{
as_edgelist(.data, twomode = FALSE)

as_matrix(.data, twomode = NULL)

as_igraph(.data, twomode = FALSE)

as_tidygraph(.data, twomode = FALSE)

as_network(.data, twomode = FALSE)

as_siena(.data, twomode = FALSE)

as_graphAM(.data, twomode = NULL)

as_diffusion(events, .data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{twomode}{Logical option used to override heuristics for
distinguishing incidence (two-mode/bipartite) from
adjacency (one-mode/unipartite) networks.
By default FALSE.}

\item{events}{A table (data frame or tibble) of diffusion events
with columns \code{t} indicating the time (typically an integer) of the event,
\code{nodes} indicating the number or name of the node involved in the event,
and \code{event}, which can take on the values "I" for an infection event,
"E" for an exposure event, or "R" for a recovery event.}
}
\value{
The currently implemented coercions or translations are:\tabular{lrrrrrrrrr}{
    \tab data.frame \tab diff_model \tab igraph \tab list \tab matrix \tab network \tab network.goldfish \tab siena \tab tbl_graph \cr
   as_edgelist \tab 1 \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   as_graphAM \tab 1 \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   as_igraph \tab 1 \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   as_matrix \tab 1 \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   as_network \tab 1 \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   as_siena \tab 0 \tab 0 \tab 1 \tab 0 \tab 0 \tab 0 \tab 0 \tab 0 \tab 1 \cr
   as_tidygraph \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}

\code{as_diffusion()} and \code{play_diffusion()} return a 'diff_model' object
that contains two different tibbles (tables) --
a table of diffusion events and
a table of the number of nodes in each relevant component (S, E, I, or R) --
as well as a copy of the network upon which the diffusion ran.
By default, a compact version of the component table is printed
(to print all the changes at each time point, use \code{print(..., verbose = T)}).
To retrieve the diffusion events table, use \code{summary(...)}.
}
\description{
The \code{as_} functions in \code{{manynet}} coerce objects of any of the following common classes
of social network objects in R into the declared class:
\itemize{
\item \code{as_edgelist()} coerces the object into an edgelist, as data frames or tibbles.
\item \code{as_matrix()} coerces the object into an adjacency (one-mode/unipartite) or incidence (two-mode/bipartite) matrix.
\item \code{as_igraph()} coerces the object into an \code{{igraph}} \code{graph} object.
\item \code{as_tidygraph()} coerces the object into a \code{{tidygraph}} \code{tbl_graph} objects.
\item \code{as_network()} coerces the object into a \code{{network}} \code{network} objects.
\item \code{as_siena()} coerces the (igraph/tidygraph) object into a SIENA dependent variable.
\item \code{as_graphAM()} coerces the object into a graph adjacency matrix.
\item \code{as_diffusion()} coerces a table of diffusion events into
a \code{diff_model} object similar to the output of \code{play_diffusion()}.
}

An effort is made for all of these coercion routines to be as lossless
as possible, though some object classes are better at retaining certain
kinds of information than others.
Note also that there are some reserved column names in one or more
object classes, which could otherwise lead to some unexpected results.
}
\details{
Edgelists are expected to be held in data.frame or tibble class objects.
The first two columns of such an object are expected to be the
senders and receivers of a tie, respectively, and are typically
named "from" and "to" (even in the case of an undirected network).
These columns can contain integers to identify nodes or character
strings/factors if the network is labelled.
If the sets of senders and receivers overlap, a one-mode network is inferred.
If the sets contain no overlap, a two-mode network is inferred.
If a third, numeric column is present, a weighted network will be created.

Matrices can be either adjacency (one-mode) or incidence (two-mode) matrices.
Incidence matrices are typically inferred from unequal dimensions,
but since in rare cases a matrix with equal dimensions may still
be an incidence matrix, an additional argument \code{twomode} can be
specified to override this heuristic.

This information is usually already embedded in \code{{igraph}},
\code{{tidygraph}}, and \code{{network}} objects.
}
\examples{
test <- data.frame(from = c("A","B","B","C","C"), to = c("I","G","I","G","H"))
as_edgelist(test)
as_matrix(test)
as_igraph(test)
as_tidygraph(test)
as_network(test)
  # How to create a diff_model object from (basic) observed data
  events <- data.frame(t = c(0,1,1,2,3), nodes = c(1,2,3,2,4), event = c("I","I","I","R","I"))
  as_diffusion(events, manynet::create_filled(4))
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
