% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProviderEspTiles.R
\name{addProviderEspTiles}
\alias{addProviderEspTiles}
\alias{providerEspTileOptions}
\title{Leaflet plugin - Spanish providers}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.2.0}.
}
\usage{
addProviderEspTiles(
  map,
  provider,
  layerId = NULL,
  group = NULL,
  options = providerEspTileOptions()
)

providerEspTileOptions(...)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{provider}{Name of the provider, see \code{\link{leaflet.providersESP.df}}.}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{...}{
  Arguments passed on to \code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions}}
  \describe{
    \item{\code{errorTileUrl}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
    \item{\code{noWrap}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
    \item{\code{opacity}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
    \item{\code{zIndex}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
    \item{\code{updateWhenIdle}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
    \item{\code{detectRetina}}{the tile layer options; see
\url{https://leafletjs.com/reference-1.3.4.html#tilelayer}}
  }}
}
\value{
Modified \code{map} object.
}
\description{
Add tiles of \url{https://dieghernan.github.io/leaflet-providersESP/} to a
\strong{R} \code{\link[leaflet:leaflet]{leaflet::leaflet()}} map.
}
\details{
Wrapper of \code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}
}
\examples{
library(leaflet)
PuertadelSol <-
  leaflet() \%>\%
  setView(
    lat = 40.4166,
    lng = -3.7038400,
    zoom = 18
  ) \%>\%
  addProviderEspTiles(provider = "IGNBase.Gris") \%>\%
  addProviderEspTiles(provider = "RedTransporte.Carreteras")

PuertadelSol
}
\seealso{
\code{\link{leaflet.providersESP.df}}, \code{\link[=esp_getTiles]{esp_getTiles()}}

\code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}, \code{\link[leaflet:map-options]{leaflet::tileOptions()}}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{imagery}
