% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_railway.R
\name{esp_get_railway}
\alias{esp_get_railway}
\title{Get railways of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_railway(
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "line"
)
}
\arguments{
\item{year}{Release year.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with:
\itemize{
\item \code{options(mapSpain_cache_dir = "path/to/dir")}.
}

See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Spatial type of the output. Use "line" for extracting
the railway and "point" for the stations.}
}
\value{
A \code{MULTILINESTRING} or \code{POINT} object.
}
\description{
Extract nodes and railways of mainland Spain and the Balearic Islands.
}
\details{
Details on caching can be found on \code{\link[=esp_get_nuts]{esp_get_nuts()}}
}
\examples{
\donttest{

provs <- esp_get_prov()
ccaa <- esp_get_ccaa()

# Railways
rails <- esp_get_railway()

# Stations
stations <- esp_get_railway(spatialtype = "point")

# Map

library(tmap)

tm_shape(provs, bbox = c(-7.5, 38, -2.5, 41)) +
  tm_polygons(col = "grey90", border.col = "grey50") +
  tm_shape(ccaa) +
  tm_borders("black") +
  tm_shape(rails) +
  tm_lines("tipo",
    legend.col.show = FALSE, lwd = 2,
    palette = "Dark2"
  ) +
  tm_shape(stations) +
  tm_symbols("red", size = .3)
}
}
\seealso{
\code{\link[=esp_get_roads]{esp_get_roads()}}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}.
}
\concept{infrastructure}
