% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_getTiles.R
\name{esp_getTiles}
\alias{esp_getTiles}
\title{Get static tiles from public administrations of Spanish.}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.2.0}.
}
\usage{
esp_getTiles(
  x,
  type = "IDErioja",
  zoom = NULL,
  zoommin = 0,
  crop = TRUE,
  res = 512,
  bbox_expand = 0.05,
  transparent = TRUE,
  mask = FALSE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{An \code{sf} object.}

\item{type}{Name of the provider. See \link{leaflet.providersESP.df}.}

\item{zoom}{Zoom level. If \code{NULL}, it is determined automatically. If set,
it overrides \code{zoommin}. Only valid for WMTS tiles. On a single point it
applies a buffer to the point and on \code{zoom = NULL} the function set a zoom
level of 18. See \strong{Details}.}

\item{zoommin}{Delta on default \code{zoom}. The default value is designed to
download fewer tiles than you probably want. Use \code{1} or \code{2} to
increase the resolution.}

\item{crop}{\code{TRUE} if results should be cropped to the specified \code{x} extent,
\code{FALSE} otherwise. If \code{x} is an \code{sf} object with one \code{POINT}, crop is set
to \code{FALSE}.}

\item{res}{Resolution (in pixels) of the final tile. Only valid for WMS.}

\item{bbox_expand}{A numeric value that indicates the expansion percentage
of the bounding box of \code{x}.}

\item{transparent}{Logical. Provides transparent background, if supported.
Depends on the selected provider on \code{type}.}

\item{mask}{\code{TRUE} if the result should be masked to \code{x}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{RasterBrick} is returned, with 3 (RGB) or 4 (RGBA) layers, depending on
the provider. See \code{\link[raster:brick]{raster::brick()}}.
.
}
\description{
Get static map tiles based on a spatial object. Maps can be fetched from
various open map servers.

This function is a implementation of the javascript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.2.0}.
}
\details{
Zoom levels are described on the
\href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{OpenStreetMap wiki}:\tabular{rl}{
   zoom \tab area to represent \cr
   0 \tab whole world \cr
   3 \tab large country \cr
   5 \tab state \cr
   8 \tab county \cr
   10 \tab metropolitan area \cr
   11 \tab city \cr
   13 \tab village or suburb \cr
   16 \tab streets \cr
   18 \tab some buildings, trees \cr
}


For a complete list of providers see \link{leaflet.providersESP.df}.

Most WMS/WMTS providers provide tiles on "EPSG:3857". In case that the tile
looks deformed, try projecting first \code{x}:

\code{x <- sf::st_transform(x, 3857)}
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontrun{
# This script downloads tiles to your local machine
# Run only if you are online

Murcia <- esp_get_ccaa_siane("Murcia", epsg = 3857)
Tile <- esp_getTiles(Murcia)

library(tmap)

tm_shape(Tile, raster.downsample = FALSE) +
  tm_rgb(interpolate = FALSE) +
  tm_shape(Murcia) +
  tm_borders()
}
}
\seealso{
\link{leaflet.providersESP.df}, \code{\link[raster:brick]{raster::brick()}}
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}}.

For plotting, you can use \code{\link[raster:plotRGB]{raster::plotRGB()}}, \code{\link[tmap:tm_raster]{tmap::tm_rgb()}}.
}
\concept{imagery}
