% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exmodel.R
\name{exmodel_exdata}
\alias{exmodel_exdata}
\alias{exmodel}
\alias{exdata}
\title{Example model and data}
\source{
\url{https://github.com/FelicienLL/mapbayr-CPTPSP-2021}
}
\usage{
exmodel(
  num = 1,
  add_exdata = TRUE,
  cache = TRUE,
  quiet = getOption("mrgsolve_mread_quiet", TRUE),
  ...,
  ID = 1,
  clean_data = TRUE
)

exdata(num = 1, ID = 1, clean_data = TRUE)
}
\arguments{
\item{num}{model number (see details)}

\item{add_exdata}{should data be automatically loaded with the model}

\item{cache}{read the model with \code{mrgsolve::mread_cache()}}

\item{quiet}{don't print messages when compiling}

\item{...}{passed to \code{mrgsolve::mread()} or \code{mrgsolve::mread_cache()}}

\item{ID}{individual number to include in the data (from 1 to 8)}

\item{clean_data}{remove useless columns and rows from the original data}
}
\value{
\code{exmodel()} reads and compiles code, and returns a (\code{mrgmod}) model object. \code{exdata()} returns a data.frame.
}
\description{
A collection of example models and corresponding data to test and explore \code{mapbayr}.
}
\details{
Available models are:
\itemize{
\item 1: Base model. A simple monocompartmental PK model with inter-individual variability on absorption constant (KA), volume of distribution (VC) and clearance (CL). The residual error model is proportional.
\item 6: Complex absorption model. Dual 0- and 1st orders absorption phenomenons.
\item 301: Time-varying covariates. A continuous covariate (body weight "BW") and a categorical one (sex "SEX") influence the clearance parameter. In the corresponding dataset, the values randomly changes from one record to another within a single individual.
\item 401: Metabolite. The PK model of both a parent drug and its metabolite.
}

An example dataset of eight (simulated) individuals is available for each model. Individuals differ in terms of sampling times (sparse or rich) and dosing regimen (single or multiple dosing).

Model code and data files are stored at the location given by \code{system.file("exmodel", package = "mapbayr")}.

These models and data were created for the validation study of \code{mapbayr} published in \href{https://pubmed.ncbi.nlm.nih.gov/34342170/}{CPT:Pharmacometrics & System Pharmacology}. More models and full datasets can be accessed \href{https://github.com/FelicienLL/mapbayr-CPTPSP-2021}{in a dedicated repository}
}
\examples{
# Models can be loaded with data (the default), ready for parameter estimation
est <- mapbayest(exmodel())

# Number of subjects in dataset can be chosen up to 8 individuals
exdata(301, ID = c(5,8))
}
