% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{layer_static_mapbox}
\alias{layer_static_mapbox}
\title{Make a ggplot2 layer with static_mapbox and ggspatial}
\usage{
layer_static_mapbox(
  location = NULL,
  buffer_dist = 1000,
  style_id,
  username,
  style_url = NULL,
  overlay_sf = NULL,
  overlay_style = NULL,
  overlay_markers = NULL,
  width = NULL,
  height = NULL,
  scale = 0.5,
  scaling_factor = c("1x", "2x"),
  attribution = TRUE,
  logo = TRUE,
  before_layer = NULL,
  access_token = NULL,
  ...
)
}
\arguments{
\item{location}{An input location for which you would like to request tiles.
Can be a length-4 vector representing a bounding box, or an sf object.
If an input sf object is supplied, use the \code{buffer_dist} argument to
control how much area you want to capture around the layer.
While the input sf object can be in an arbitrary coordinate reference system,
if a length-4 bounding box vector is supplied instead it must represent
WGS84 longitude/latitude coordinates and be in the order
\code{c(xmin, ymin, xmax, ymax)}.}

\item{buffer_dist}{The distance to buffer around an input sf object for
determining static map, specified in meters.  Defaults to 1000.}

\item{style_id}{A style ID (required if style_url is NULL).}

\item{username}{A Mapbox username (required if style_url is NULL).}

\item{style_url}{A Mapbox style url; defaults to NULL.}

\item{overlay_sf}{The overlay sf object (optional).  The function will
convert the sf object to GeoJSON then plot over the basemap style.  Spatial
data that are too large will trigger an error, and should be added to the
style in Mapbox Studio instead.}

\item{overlay_style}{A named list of vectors specifying how to style the sf
overlay.  Possible names are "stroke", "stroke-width", "stroke-opacity",
"fill", and "fill-opacity".  The fill and stroke color values should be
specified as six-digit hex codes, and the opacity and width values should
be supplied as floating-point numbers.}

\item{overlay_markers}{The prepared overlay markers (optional).  See the
function \code{\link{prep_overlay_markers}} for more information on how to
specify a marker overlay.}

\item{width}{The map width; defaults to NULL}

\item{height}{The map height; defaults to NULL}

\item{scale}{ratio to scale the output image; `scale = 1` will return the
largest possible image. defaults to 0.5}

\item{scaling_factor}{The scaling factor of the tiles; either \code{"1x"}
(the default) or \code{"2x"}}

\item{attribution}{Controls whether there is attribution on the image.
Defaults to `TRUE`. Note: If attribution=false, the watermarked attribution
is removed from the image. You still have a legal responsibility to
attribute maps that use OpenStreetMap data, which includes most maps from
Mapbox. If you specify attribution=false, you are legally required to
include proper attribution elsewhere on the webpage or document.}

\item{logo}{Controls whether there is a Mapbox logo on the image. Defaults to
`TRUE`.}

\item{before_layer}{A character string that specifies where in the hierarchy
of layer elements the overlay should be inserted.  The overlay will be
placed just above the specified layer in the given Mapbox styles.}

\item{access_token}{A Mapbox access token; can be set with
\code{mb_access_token()}.}

\item{...}{additional parameters passed to \code{\link[ggspatial]{layer_spatial}}}
}
\description{
Make a ggplot2 layer with static_mapbox and ggspatial
}
