% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{get_drawn_features}
\alias{get_drawn_features}
\title{Get drawn features from the map}
\usage{
get_drawn_features(map)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} function, or a mapboxgl proxy.}
}
\value{
An sf object containing the drawn features.
}
\description{
Get drawn features from the map
}
\examples{
\dontrun{
# In a Shiny application
library(shiny)
library(mapgl)

ui <- fluidPage(
    mapboxglOutput("map"),
    actionButton("get_features", "Get Drawn Features"),
    verbatimTextOutput("feature_output")
)

server <- function(input, output, session) {
    output$map <- renderMapboxgl({
        mapboxgl(
            style = mapbox_style("streets"),
            center = c(-74.50, 40),
            zoom = 9
        ) |>
            add_draw_control()
    })

    observeEvent(input$get_features, {
        drawn_features <- get_drawn_features(mapboxgl_proxy("map"))
        output$feature_output <- renderPrint({
            print(drawn_features)
        })
    })
}

shinyApp(ui, server)
}
}
