% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_scale_control}
\alias{add_scale_control}
\title{Add a scale control to a map}
\usage{
add_scale_control(
  map,
  position = "bottom-left",
  unit = "metric",
  max_width = 100
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{position}{The position of the control. Can be one of "top-left", "top-right", "bottom-left", or "bottom-right". Default is "bottom-left".}

\item{unit}{The unit of the scale. Can be either "imperial", "metric", or "nautical". Default is "metric".}

\item{max_width}{The maximum length of the scale control in pixels. Default is 100.}
}
\value{
The modified map object with the scale control added.
}
\description{
This function adds a scale control to a Mapbox GL or Maplibre GL map.
}
\examples{
\dontrun{
library(mapgl)

mapboxgl() |>
    add_scale_control(position = "bottom-right", unit = "imperial")
}
}
