% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_filter}
\alias{turf_filter}
\title{Spatial filter features by predicate}
\usage{
turf_filter(
  map,
  layer_id = NULL,
  filter_layer_id = NULL,
  data = NULL,
  filter_data = NULL,
  predicate = c("intersects", "within", "contains", "crosses", "disjoint"),
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of the layer or source to filter (mutually exclusive with data).}

\item{filter_layer_id}{The ID of the layer or source to filter against (mutually exclusive with filter_data).}

\item{data}{An sf object containing features to filter (mutually exclusive with layer_id).}

\item{filter_data}{An sf object containing the filter geometry (mutually exclusive with filter_layer_id).}

\item{predicate}{The spatial relationship to test. One of: "intersects", "within", "contains", "crosses", "disjoint".}

\item{source_id}{The ID for the new source containing the filtered results. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function filters features from the first layer based on their spatial relationship
with features in the second layer using various spatial predicates.
}
