% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_precipitation_chirps.R
\name{precipitation_chirps}
\alias{precipitation_chirps}
\alias{calc_precipitation_chirps}
\title{Calculate precipitation statistics based on CHIRPS}
\usage{
calc_precipitation_chirps(
  years = 1981:2020,
  engine = "extract",
  scales_spi = 3,
  spi_prev_years = 8
)
}
\arguments{
\item{years}{A numeric vector indicating the years for which to calculate
precipitation statistics.}

\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{scales_spi}{Integers specifying time-scales for SPI}

\item{spi_prev_years}{Integer specifying how many previous years to include in
order to fit the SPI. Defaults to 8.}
}
\value{
A function that returns a tibble with a column for years, months,
absolute rainfall (in mm), rainfall anomaly (in mm) and one or more columns
per selected time-scale for SPI (dimensionless).
}
\description{
This functions allows to calculate precipitation statistics based on the
CHIRPS rainfall estimates. Corresponding to the time-frame of the analysis
of the portfolio, monthly precipitation statistics are calculated. These include
the total rainfall amount, rainfall anomaly against the 1981-2010 climate normal,
and the Standardized Precipitation Index (SPI) which is available for scales
between 1 and 48 months. Th function needs the \code{SPEI} package to be
installed.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{chirps}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_chirps()) \%>\%
  calc_indicators(
    calc_precipitation_chirps(
      years = 2010,
      engine = "extract",
      scales_spi = 3,
      spi_prev_years = 8
    )
  ) \%>\%
  tidyr::unnest(precipitation_chirps)

aoi
}
}
\keyword{indicator}
