% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_factory.R
\name{get_edge_weights}
\alias{get_edge_weights}
\title{Calculate edge weights}
\usage{
get_edge_weights(overlap_lengths, cluster_sizes, edges)
}
\arguments{
\item{overlap_lengths}{A named vector of cluster overlap lengths, obtained by calling \code{\link[=length]{length()}} on the output from \code{[get_overlaps()]}.}

\item{cluster_sizes}{A vector of cluster sizes.}

\item{edges}{A 2D array of source and target nodes, representing an edge list. Should be ordered consistently with the \code{overlap_lengths} parameter.}
}
\value{
A vector of real numbers representing cluster overlap strength.
}
\description{
Calculate edge weights
}
\details{
This value is calculated per edge by dividing the number of data points in the overlap by the number of points in the cluster on either end, and taking the maximum value. Formally, \deqn{w(\{c_i, c_j\}) = \displaystyle\max\left\{\dfrac{|c_i \cap c_j|}{|c_i|}, \dfrac{|c_i\cap c_j|}{|c_j|}\right\}}
}
