% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_genoprob_dist.R
\name{calc_genoprob_dist}
\alias{calc_genoprob_dist}
\title{Compute conditional probabilities of the genotypes using probability distribution of dosages}
\usage{
calc_genoprob_dist(
  input.map,
  dat.prob = NULL,
  phase.config = "best",
  verbose = TRUE
)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{dat.prob}{an object of class \code{mappoly.data} containing the
probability distribution of the genotypes}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the phase configuration with the
maximum likelihood}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class 'mappoly.genoprob' which has two elements: a tridimensional
array containing the probabilities of all possible genotypes for each individual
in each marker position; and the marker sequence with it's recombination frequencies
}
\description{
Conditional genotype probabilities are calculated for each marker
position and each individual given a map. In this function,
the probabilities are not calculated between markers.
}
\examples{
 ## tetraploid example
 probs.t<-calc_genoprob_dist(input.map = solcap.prior.map[[1]],
                           dat.prob = tetra.solcap.geno.dist,
                           verbose = TRUE)
 probs.t
 ## displaying individual 1, 36 genotypic states 
 ## (rows) across linkage group 1 (columns)                          
 image(t(probs.t$probs[,,1]))

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
